/*
 * $Header: /home/vikas/src/xtacacsd/RCS/common.h,v 1.4 1998/01/05 05:24:57 vikas Exp $
 */

/*
 * Common definitions for the tacacs routines.
 */

#if defined(SYSV) || defined(SVR4) || defined(__svr4__)
# define index strchr
# define bcopy(src,dest,len)     (memmove((dest), (src), (len)))
# define bzero(dest,len)       (memset((dest), (char)0, (len)))
#endif

#ifdef tolower			/* because some OS's screwed up  */
# undef tolower
# define tolower(_c) (isupper(_c)?((_c)-'A'+'a'):(_c))
#endif

#ifdef NEED_FD_MACROS
#ifndef NFDBITS
typedef long    fd_mask;
# define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
# ifndef FD_SETSIZE
#  define FD_SETSIZE      256
# endif
typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
# define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
# define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
# define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
# define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
#endif	/* NEED_FD_MACROS */

/*+
 **
 **		CUSTOMIZE THE FOLLOWING DEFINES
 **
 */
/*
 * The 'utmp' format file which is scanned for checking the number of
 * allowed logins. This file is different from the 'WTMP' file, since 
 * it indicates the *current* logins as opposed to the 'wtmp' file which
 * is the history of the user logging in/out. This file is now maintained
 * and updated by this daemon (for controlling the number of logins).
 * Preferably, do NOT give the /etc/utmp file.
 */
#ifndef UTMP
#define UTMP  "/var/adm/tacacs/utmp"	/* also edit tacutmp.h */
#endif

/*
 * The  WTMP file will be updated for all records. This helps
 * counting of logins and helps keep track of all logins into your net.
 *
 * It is advised to specify a different directory for these wtmp/utmp files.
 *
 */
#ifndef WTMP
#define WTMP  "/var/adm/tacacs/wtmp"	/* also edit tacutmp.h */
#endif

#ifndef PASSWD
#define PASSWD  "/etc/passwd"		/* default password file */
#endif

/*
 * For cisco terminal servers that authenticate 'slip default', set the 
 * 'default' password here. Only used for SLIP queries.
 */
#define DEFAULTS_IP_PASSWORD	"default"

/*
 * For enable type requests, the username checked is ENABLE_USERNAME if
 * defined. If not, you should control it using the config file & permissions
 * since the user will be able to do a 'enable' with his/her regular
 * password.
 */
/* # define ENABLE_USER		"$enable$"	/*  */

/***** Other possible options that can be defined while compiling: ****/

/* #define DEBUG	/* Extensive debugging info */
/* #define SYSV      	/* If no BSD4.3 stuff like malloc(), ioctl() */
/* #define BSDI      	/* No multiple password files on BSDI */

#ifndef LOG_FACILITY
# define LOG_FACILITY LOG_LOCAL6	/* any 'syslog 5' type facility */
#endif

/*
 * When a user logs in, he/she is logged in with the terminal type of
 * TS_TTY. When they invoke slip, an entry is logged with the terminal
 * type of SLIP_TTY.
 *
 * Typical sequence of events:
 * LOGIN --> SLIPON --> LOGOUT  --> SLIPOFF
 *
 * Does the 'ac' program accept wierd terminal type names (like 'sli') ?
 */
#define SLIP_TTY	"sli"		/* slip terminal type */
#define TS_TTY		"tty"		/* 'connect' tty type */

#define oresponse namelen
#define oreason pwlen
#define	TIMEOUT		(15*60)		/* inactivity timer under inetd */

#define	TACACS_PORT	49

#define SEC_IN_DAY      (24*60*60)	/* seconds in a day */
#define WARNING_PERIOD  14		/* days of expiration warning */
#define PASSWD_LENGTH	14		/* length of password for crypt */
#define SOME_ARBITRARILY_LARGE_NUMBER 100
#define MAX_PASSWD_FILES 5		/* max number of 'passwd' files	*/

#define ALL_REQUESTS	255	/* pseudo xtacacs typecode (for check_perm) */
#define OLD_REQUEST	254	/* pseudo xtacacs typecode (for check_perm) 
				   indicating old query type */

#define ALL_ENABLE_LEVEL 65535	/* pseudo maximum enable level possible */
#define MAX_ENABLE_LEVEL 15	/* Max level in v10.3 and higher */

/* Authentication return codes */
#define A_ERROR  -2
#define A_NOUSER -1
#define A_FAIL    0
#define A_PASS    1


#ifndef MAIN
# define EXTERN extern
#else
# define EXTERN
#endif
EXTERN int debug;			/* debugging flag */
EXTERN int ignorecase;			/* ignore case in username matches */
EXTERN int logging;			/* syslog logging flag */
EXTERN int stand;			/* running standalone or not */
EXTERN int quiet ;			/* dont send 'denied' response */
EXTERN int Quiet ;			/* no denied if user not found */
EXTERN int blankpassword;		/* allow blank passwords */
EXTERN int nonameserver;		/* using name server or not */
EXTERN int pwfilect;			/* password file count */
EXTERN int newstyle_query;		/* new xtacacs requests */
EXTERN int do_system_pw;		/* search in default passwd file */
EXTERN int interruptible;		/* unset in critical write code */
EXTERN int update_host_wtmp ;		/* maintain WMTP.<hostname> also */
EXTERN int wtmpfd, utmpfd;		/* file descriptors */
EXTERN int fromlen;

EXTERN char *configfile;		/* Config file */
EXTERN char *utmp_file ;		/* 'utmp' file for present logins */
EXTERN char *wtmp_file ;		/* Main 'wtmp' format file */
EXTERN long abort_timeout;		/* if processing takes too long */
EXTERN long expiredays;			/* number of days for passwd expiry */
EXTERN unsigned long querytime;		/* time query came in */
EXTERN struct sockaddr_in from;

EXTERN char *pwfile[];			/* set in xtacacsd.c */
EXTERN char from_hname[];		/* set in xtacacsd.c */

#undef EXTERN

char *skip_spaces(), *Strdup();	/* for those broken OS's without Strdup() */
struct passwd *Getpwnam();	/* replacement for getpwnam() */
struct passwd *search_pwname();

extern char *inet_ntoa();
/* extern char *malloc();		/* DONT include malloc.h */

#if !defined(__FreeBSD__) && !defined(__BSDI__) && !defined(HAVESYSERR)
extern char *sys_errlist[];
#endif

