/*
 * $Header: /home/vikas/src/xtacacsd/RCS/charap.c,v 1.3 1997/05/28 20:08:03 vikas Exp $
 */

/*
 * CHAP and ARAP interface to xtacacsd. Routines that were earlier
 * in the xtacacsd.c file. More log comments in that file.
 *
 *	-vikas aggarwal, vikas@navya.com
 *
 * $Log: charap.c,v $
 * Revision 1.3  1997/05/28 20:08:03  vikas
 * Changes to function names to use xmd5.c instead of md5.c so that
 * the md5 routine names dont clash with any system libraries.
 *
 * Revision 1.2  1997/04/14 03:58:33  vikas
 * Added a comment about why we are subtracting 1 from the CHAP pwlen.
 *
 * Revision 1.1  1995/07/14 16:18:18  vikas
 * Initial revision
 *
 */


#ifndef lint
 static char rcsid[] = "$RCSfile: charap.c,v $ $Revision: 1.3 $ $Date: 1997/05/28 20:08:03 $" ;
 static char sccsid[] = "$RCSfile: charap.c,v $ $Revision: 1.3 $ $Date: 1997/05/28 20:08:03 $" ;
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <syslog.h>

#ifdef CHAP_SUPPORT
# include "xmd5.h"
#endif /* CHAP_SUPPORT */

#include "tacacs.h"

#if defined(SYSV) || defined(SVR4) || defined(__svr4__)
#  define index strchr
#  define bcopy(a, b, c) memmove(b, a, c)
#  define bzero(a, b)    memset(a, 0, b)
#endif

#ifdef ARAP_SUPPORT
create_arap_resp (tp, pw)
     xtacacstype *tp;
     struct passwd *pw;
{
    int resplen;
    char *chal_1, *chal_2, resp_1[8], resp_2[8];

    /* For ARAP, encrypt the chal1 and chal2 using the users password
     * (stored locally) as the DES key.
     */
    if (tp->type != XTA_ARAP_AUTH)
      return (0);

    /* chal_1 is from the remote client, chal_2 is from commServer */
    chal_1 = ((char *)tp) + XTACACSSIZE + tp->namelen;
    chal_2 = ((char *)tp) + XTACACSSIZE + tp->namelen + ARAP_CHAL_SIZE;
    if (pw != NULL && pw->pw_passwd != NULL) {
	if (arap_do_des(pw->pw_passwd, chal_1, chal_2, resp_1, resp_2) != 0)
	 report(LOG_ERR, "create_arap_resp: arap_do_des return not 0.");
	else
	  bzero(pw->pw_passwd,sizeof(pw->pw_passwd)); /* zero the secret */
    }

    /* We have to fudge things for ARAP - we need the responses
     * to the challenges - not the username, at the end of the
     * xtacacs packet
     */
    tp->namelen = 0;
    tp->pwlen = (ARAP_RESP_SIZE * 2);
    bcopy(resp_1, ((char *)tp) + XTACACSSIZE, ARAP_RESP_SIZE);
    bcopy(resp_2, ((char *)tp) + XTACACSSIZE + ARAP_RESP_SIZE,
	  ARAP_RESP_SIZE);
    resplen = sizeof(xtacacstype) + (2 * ARAP_RESP_SIZE) ; 

    return (resplen);

}	/* end create_arap_resp() */


/*
 * Do the DES operations on the two challenge values and put the results
 * in the two responses.
 * Return 0 for success.
 */
arap_do_des(secret, chal_1, chal_2, resp_1, resp_2)
  char *secret, *chal_1, *chal_2, *resp_1, *resp_2;
{
    des_pw_bitshift(secret);

    des_init(0);
    des_setkey(secret);
    des_endes(chal_1);
    des_done();

    des_init(0);
    des_setkey(secret);
    des_endes(chal_2);
    des_done();

    bcopy(chal_1, resp_1, ARAP_RESP_SIZE);
    bcopy(chal_2, resp_2, ARAP_RESP_SIZE);

    return(0);
}

#endif /* ARAP_SUPPORT */

#ifdef CHAP_SUPPORT
/*+
 * The "pwlen" field (and the password field) both include the CHAP
 * "ident" as well as the actual challenge. Hence, we need to subract
 * 1 to get the challenge length.
 */
create_chap_resp(tp, pw)
     xtacacstype *tp;
     struct passwd *pw;
{
    int chal_len, resplen;
    char *chal_1, *chal_2, resp_1[8], resp_2[8];
    char chap_resp[MD5_LEN];
    char chap_id;

    if (tp->type != XTA_CHAP_AUTH)
      return 0;

    chap_id = *(((char *)tp) + XTACACSSIZE + tp->namelen);
    chal_len = tp->pwlen - 1;	/* delete the size of the CHAP "ident" */
    if ((chal_1 = (char *)malloc(chal_len)) == NULL) {
	report(LOG_ERR,"create_chap_resp: failed to malloc CHAP challenge\n");
	return (0);/* return dumbly */
    }

    bcopy(((char *)tp) + XTACACSSIZE + tp->namelen + 1, chal_1, chal_len);
	    
    if (pw != NULL && pw->pw_passwd != NULL) {
	if (chap_do_md5(chap_id, pw->pw_passwd, 
			chal_1, chal_len, chap_resp) != 0)
	  report(LOG_ERR, "create_chap_resp: chap_do_md5 return not 0\n");
	else
	  bzero(pw->pw_passwd, sizeof(pw->pw_passwd)); /* null the secret */
    }

    tp->namelen = 0;
    tp->pwlen = (MD5_LEN);
    bcopy(chap_resp, ((char *)tp) + XTACACSSIZE, MD5_LEN);
    resplen = sizeof(xtacacstype) + MD5_LEN ;

    return (resplen);
}	/* end: create_chap_resp() */

/*
 * chap_do_md5()
 * Does an md5 hash of the stream of the following three:
 *	"the id", "the user's secret (stored locally)", "the challenge"
 * Returns 0 on success.
 */
chap_do_md5(id, secret, chal, chal_len, resp)
  char id, *secret, *chal;
    int chal_len;
    char *resp;
{
    char *md_stream;
    int md_len;
    x_MD5_CTX mdcontext;

    md_len = 1 + strlen(secret) + chal_len;
    md_stream = (char *)malloc(md_len);
    if(!md_stream) {
#ifdef DEBUG
	fprintf(stderr, "chap_do_md5(): malloc failed.\n");
#endif /* DEBUG */
	return(-1);
    }
#ifdef DEBUG_HAIRY
    fprintf(stderr, "chap_do_md5(): id = %d, secret = \"%s\", chal_len = %d\n",
	    (int)id, secret, chal_len);
#endif /* DEBUG_HAIRY */
    md_stream[0] = id;
    strcpy(&md_stream[1], secret);
    bcopy(chal, &md_stream[1 + strlen(secret)], chal_len);

    x_MD5Init(&mdcontext);
    x_MD5Update(&mdcontext, md_stream, md_len);
    x_MD5Final(resp, &mdcontext);
    free(md_stream);
    return(0);
}

#endif /* CHAP_SUPPORT */

