.\" $Id: Getpw.man,v 1.2 1997/04/14 04:36:48 vikas Exp $
.\"
.TH GETPW 8  "April 1, 1996"
.SH NAME
Getpw \- Create DBM format databases from password files.
.SH SYNOPSIS
.B Getpw
[
.B  \-d
.I (debug)
]
[
.B \-c
.I (create DBM database)
]
.I password-file
[
.I username
]
.\" ******************************************************************
.SH DESCRIPTION
.LP
.B Getpw
consists of routines to extract Unix style password fields and fill in
the
.B passwd
structure (see pwd.h)  from Unix style
.IR passwd (5)
files. It can create DBM style indexes where the key is the username and
the data is the entire password line, and hence fetch the password file
entry for a user extremely fast (newer Unix's are also doing this for their
system password files, but Getpw allows doing this for any arbitrary passwd
file which might be used by xtacacsd). The internal routines look for
a DBM database in the same location as the passwd file being looked up,
and if such files are present, they try extracting the username from these
files. In case a fetch from the DBM file fails, then the entry is retrieved
from the ascii passwd file automatically.
.LP
.B Getpw
uses the system's pwd.h structure (not its own).
It expects the following fields in a BSD password file:
.sp .25
.nf
    name : password : uid : gid : gecos : homedir : shell
.fi
.sp .25
On a SysV machine, it expects the following additional fields after the gid:
.sp .25
.nf
     pw_age
     pw_comment
.fi
.sp .25
It tries to detect a BSD type file on a sysV platform, but it is preferable
to add these extra fields on a SysV machine (e.g. if you are migrating from
SunOS to Solaris and copy your tacacs password file over).
.LP
Typically this module is used as a programming interface to replace the
ever changing getpwnam() getpwent()  routines. To generate DBM format
databases, this can be compiled in standalone mode and then one can use
the
.B \-c
command line option. For case-insensitive searching, Getpw stores names with
their regular case as well as all lower case in the dbm database.
.LP
You can test the 
.I Getpwnam() 
routine  by specifying a username on the command line. Specify
.B \-d
for debugging output.
.SH LIMITATIONS
.IP 1.
Can not handle shadow password entries. Getpw is NOT meant to be a
replacement for Unix's getpwent() routines used by the Unix system.
.IP 2.
Does not rebuild the dbm databases automatically.
.IP 3.
Does not have corresponding routines to deal with alternate group files.
.SH AUTHOR
Vikas Aggarwal (vikas@navya.com)  written for the xtacacsd software.
.SH FILES
.I /etc/passwd
.SH SEE ALSO
.IR passwd (5), 
.IR /usr/include/pwd.h ,
.IR xtacacsd (8),
.IR xpasswd (n).

