/*
 * pt_sh : pt_symbol.c
 */

#include <strings.h>
#include <stdio.h>
#include "pt_symbol.inc"
#include "pt_symbol.h"


char ptsymbol_name[1024];

int get_syscall(char *name)
{
  int i;
  for(i=0; syscall_symbols[i]; i++)
  {
    if(!strcmp(syscall_symbols[i], name))
      return i+1;
  }
  return -1;
}

int get_signum(char *name)
{
  int i;
  for(i=0; signal_symbols[i]; i++)
  {
    if(!strcmp(signal_symbols[i], name))
      return i+1;
  }
  return -1;
}

char *get_syscallname(int sysnum)
{
  sysnum--;
  if((sysnum>=0) && (sysnum < LAST_SYSCALL))
    if(syscall_symbols[sysnum]) return syscall_symbols[sysnum];
  snprintf(ptsymbol_name, 1024, "unknow syscall %d", sysnum+1);
  return ptsymbol_name;
}

char *get_signalname(int signum)
{
  signum--;
  if((signum>=0) && (signum < SIGUNUSED))
    if(signal_symbols[signum]) return signal_symbols[signum];
  snprintf(ptsymbol_name, 1024, "unknow signal %d", signum+1);
  return ptsymbol_name;
}
