/*
 * pt_sh : trivial debugger using ptrace()
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pt_box.h"
#include "pt_symbol.h"

void run(char *argv[]);
void do_query(char *argv[]);
char **get_arg_list();

int main(int argc, char *argv[])
{
  printf("pt_sh : another stupid tool using ptrace()\n\n");
  if(argc<2)
  {
    fprintf(stderr, "syntax : %s program [arg1 [arg2 ...]]\n", argv[0]);
    exit(-1);
  }
  
  restart(&(argv[1]));
  run(&(argv[1]));
  return 0;
}

void help()
{
  printf("command list :\n");
  printf("    quit, exit			exit pt_sh\n");
  printf("    restart			restart the child\n");
  printf("    end				detach the child\n");
  printf("\n");
  printf("    map				view map file of the child\n");
  printf("    x addr			view word at address addr\n");
  printf("    reg [reg1 reg2 ...]		show registers\n");
  printf("    set {reg|addr} value	set register reg or word at addr to value\n");
  printf("    dump[c] addr size		dump size bytes from addr to the screen\n");
  printf("         c is to have a dump byte per byte\n");
  printf("    dumpfile addr size f	idem but into file f\n");
  printf("\n");
  printf("    cont [s]			go to the next signal\n");
  printf("         (s is for waiting a specific signal)\n");
  printf("    next [s]			go to the next syscall\n");
  printf("         (s is for waiting a specific syscall)\n");
  printf("    step [addr]		go to the next instruction\n");
  printf("         (addr is for going to a specific addr)\n");
  printf("    signal s			send the signal s to the child\n");
  printf("    kill s                    send signal s and detach\n");
  printf("\n");
  printf("    help, ?			this help\n\n");
}

void run(char *argv[])
{
  int c;
  while(1)
  {
    if(!childrunning())
    {
      printf("Do you want to restart the program ? (Y/n) ");
      c = getchar();
      if((c=='n') || (c=='N'))
        return;
      else restart(argv);
    }
    do_query(argv);
  }
}

char** get_arg_list()
{
  int i;
  static char *arglist[128];
  for(i=0; i<127; i++)
    if(!(arglist[i] = strtok(NULL, " \t\n"))) return i ? arglist : NULL;
  arglist[127] = NULL;
  return arglist;
}

void do_query(char *argv[])
{
  char buf[1024];
  char *cmd, *arg;
  unsigned long addr;
  unsigned long val;
  
  printf("pt_sh%% ");
  fgets(buf, 1024, stdin);
  buf[1023] = 0;

  cmd = strtok(buf, " \t\n");
  if(!cmd) return;
  switch(cmd[0])
  {
    case 'q':
    case 'e':
      if((cmd[1] == 'n') && (cmd[0] == 'e'))
      {
        if(!strstr("end", cmd))
          fprintf(stderr, "unknow command %s !\n", cmd);
        else end();
      }
      else if(!cmd[1] && (cmd[0] == 'e'))
        fprintf(stderr, "ambiguous command %s !\n", cmd);
      else if((!strstr("quit", cmd)) && (!strstr("exit", cmd)))
        fprintf(stderr, "unknow command %s !\n", cmd);
      else
      {
        end();
        exit(0);
      }
      break;

    case 'r':
      switch(cmd[1])
      {
        case 'e':
          switch(cmd[2])
          {
            case 's':
              if(!strstr("restart", cmd))
                fprintf(stderr, "unknow command %s !\n", cmd);
              else restart(argv);
              break;
            case 'g':
              if(cmd[3]) fprintf(stderr, "unknow command %s !\n", cmd);
              else get_regs(get_arg_list());
              break;
            case 0:
              fprintf(stderr, "ambiguous command %s !\n", cmd);
              break;
            default:
              fprintf(stderr, "unknow command %s !\n", cmd);
              break;
          }
          break;
        case 0:
          fprintf(stderr, "ambiguous command %s !\n", cmd);
          break;
        default:
          fprintf(stderr, "unknow command %s !\n", cmd);
      }
      break;
    
    case 's':
      switch(cmd[1])
      {
        case 'e':
          if(!strstr("set", cmd))
          {
            fprintf(stderr, "unknow command %s !\n", cmd);
            break;
          }
          cmd = strtok(NULL, " \t\n");
          arg = strtok(NULL, " \t\n");
          if(!cmd || !arg)
          {
            fprintf(stderr, "syntax : set {register|addresse} newval\n");
            break;
          }
          val = (arg[0] == '0') ? (arg[1] == 'x') ? strtoul(arg+2, NULL, 16)
                                                  : strtoul(arg+1, NULL, 8)
                                                  : atoi(arg);
          if(isalpha(cmd[0]))
            set_reg(cmd, val);
          else set_addr(strtoul(cmd, NULL, 16), val);
          break;
        case 'i':
          if(!strstr("signal", cmd))
          {
            fprintf(stderr, "unknow command %s !\n", cmd);
            break;
          }
          arg = strtok(NULL, " \t\n");
          if(!arg)
          {
            fprintf(stderr, "syntax : signal s\n");
            break;
          }
          if(isalpha(arg[0])) val = get_signum(arg);
          else val = atoi(arg);
          if(val <= 0)
            fprintf(stderr, "syntax : signal s\n");
          else send_sig(val);
          break;
        case 't':
          if(!strstr("step", cmd))
            fprintf(stderr, "unknow command %s !\n", cmd);
          else 
          {
            arg = strtok(NULL, " \t\n");
            if(!arg)
              step();
            else
            {
              val = (arg[0] == '0') ? (arg[1] == 'x') ? strtoul(arg+2, NULL, 16)
                                                      : strtoul(arg+1, NULL, 8)
                                                      : atoi(arg);
              mgoto(val);
            }
          }
          break;
        case 0:
          fprintf(stderr, "ambiguous command %s !\n", cmd);
          break;
        default:
          fprintf(stderr, "unknow command %s !\n", cmd);
      }
      break;

    case 'x':
      if(cmd[1]) fprintf(stderr, "unknow command %s !\n", cmd);
      else
      {
        arg = strtok(NULL, "\t\n ");
        if(arg) get_addr(strtoul(arg, NULL, 16));
        else fprintf(stderr, "syntax : x addr\n");
      }
      break;

    case 'm':
      if(!strstr("map", cmd))
        fprintf(stderr, "unknow command %s !\n", cmd);
      else print_map();
      break;
    
    case 'c':
      if(!strstr("cont", cmd))
        fprintf(stderr, "unknow command %s !\n", cmd);
      else
      {
        arg = strtok(NULL, "\t\n ");
        if(arg)
        {
          if(isalpha(arg[0])) val = get_signum(arg);
          else val = atoi(arg);
          if(val<=0)
            fprintf(stderr, "syntax : cont [signal]\n");
          else break_signal(val);
	}
	else cont();
      }
      break;
      
    case 'n':
      if(!strstr("next", cmd))
        fprintf(stderr, "unknow command %s !\n", cmd);
      else
      {
        arg = strtok(NULL, "\t\n ");
        if(arg)
        {
          if(isalpha(arg[0])) val = get_syscall(arg);
          else val = atoi(arg);
          if(val<=0)
            fprintf(stderr, "syntax : next [signal]\n");
          else break_syscall(val);
	}
	else next();
      }
      break;

    case 'd':
      if(strstr(cmd, "dump") != cmd)
        fprintf(stderr, strstr("dump", cmd) ? "ambigous command %s !\n"
                                            : "unknow command %s !\n", cmd);
      else
      {
        arg = strtok(NULL, "\t\n ");
        if(!arg)
        {
          fprintf(stderr, "syntax : dump[c|file] addr size [file]\n");
          break;
        }
        addr = strtoul(arg, NULL, 16);
        arg = strtok(NULL, "\t\n ");
        if(!arg)
        {
          fprintf(stderr, "syntax : dump[c|file] addr size [file]\n");
          break;
        }
        val = strtoul(arg, NULL, 16);
        switch(cmd[4])
        {
          case 'c':
            if(cmd[5]) fprintf(stderr, "unknow command %s !\n", cmd);
            else hexdump(addr, val, 1);
            break;
          case 0:
            hexdump(addr, val, 0);
            break;
          case 'f':
            if(!strstr("dumpfile", cmd)) 
              fprintf(stderr, "unknow command %s !\n", cmd);
            else
            {
              arg = strtok(NULL, "\t\n ");
              if(!arg) fprintf(stderr, "syntax : dumpfile addr size file\n");
              else dumpfile(addr, val, arg);
            }
            break;
          default:
            fprintf(stderr, "unknow command %s !\n", cmd);
        }
      }
      break;

    case 'k':
      if(!strstr("kill", cmd))
        fprintf(stderr, "unknow command %s !\n", cmd);
      else
      {
        arg = strtok(NULL, " \t\n");
        if(!arg)
        {
          fprintf(stderr, "syntax : signal s\n");
          break;
        }
        if(isalpha(arg[0])) val = get_signum(arg);
        else val = atoi(arg);
        if(val <= 0)
          fprintf(stderr, "syntax : signal s\n");
        else mkill(val);
      }
      break;
    case '?':
    case 'h':
      if((!strstr("help", cmd)) && strcmp("?", cmd))
      {
        fprintf(stderr, "unknow command %s !\n", cmd);
        break;
      }
      help();
      break;

    case 0:
      break;
    default:
      fprintf(stderr, "unknow command %s !\n", cmd);
      break;
  }
}
    
