/*
     Verify that this user/password is valid per a database LDAP server
     Return 1 if verified, 0 otherwise.
     
     Format of connection string (look like internet URL):

       ldap://LDAP-hostname
     
     -------------------------------------------------------
     patrick.harpes@tudor.lu            http://www.santel.lu
                                        http://www.tudor.lu
     


     Dependencies: You need to get the OpenLDAP libraries
                   from http://www.openldap.org
 
      License: tac_ldap is free software; you can redistribute it
               and/or modify it under the terms of the GNU General Public License
               as published by the Free Software Foundation; either version 2,
               or (at your option) any later version.
--------------------------------------------------------------------------
				Changes:
 Ok i am back again..:)
 I changed lot of thing.. First off all i add port feature to ldap string.
 And also add more check for buffer overflows.

Connect format would be:
       ldap://LDAP-hostname:100

Port name isn't required.. I would like to change format with : 
       ldap://LDAP-hostname:100/dn_for_user&dn_for_passwd

 devrim seral <devrim@gazi.edu.tr> 

*/ 


#if defined(USE_LDAP)
#include <stdio.h>
#include <string.h>
#include <lber.h>
#include <ldap.h>
#include <ldap_cdefs.h>

#include "tac_plus.h"
#include "ldap.h"


int
ldap_verify(user, users_passwd, str_conn)
char *user, *users_passwd;      /* Username and gived password   */
char *str_conn;                 /* String connection to database */
{
  char *buf;
  char *ldapServer;
  char *ldap_port;
  LDAP *ld;
  int port;
  int err;

/* Don't allow null username and passwd */ 
  if ( *user == '0' || *users_passwd == '0' ) return (1);

  buf=(char *)malloc(strlen(str_conn)+1);
  if (buf == NULL ){ 
	report(LOG_DEBUG, "Error can't allocate memory");
        return(1);
  }
  
  strcpy(buf,str_conn);
  ldapServer=strstr(buf, "://");
  
  if(ldapServer == NULL && strlen(ldapServer) <4 ) {
	if (debug) {
		report(LOG_DEBUG, "Error parse ldap server");
		return(1);
	}
  } 
  
 ldapServer=ldapServer+3;

 ldap_port=(char *)strstr(ldapServer, ":");

 if (ldap_port != NULL ) {
		*ldap_port='\0';
		port=atoi(++ldap_port);
 } else {
	port = LDAP_PORT;
 }
 
 if ( debug & DEBUG_AUTHEN_FLAG ) 
  report(LOG_DEBUG, "In verify_ldap : Before ldap_init : ldapserver = %s port= %d", ldapServer, port);


  if( (ld = ldap_init(ldapServer, port)) == NULL)
    {
      report(LOG_DEBUG, "Unable to connect to LDAP server:%s port:%d",ldapServer, port);
      return 1;
    }
  
  err=ldap_simple_bind_s(ld, user, users_passwd);
  
  if(err != LDAP_SUCCESS)
    {
      if ( debug & DEBUG_AUTHEN_FLAG ) 
      	report(LOG_DEBUG,"Error while bind : %d %s",err, ldap_err2string(err) );
      return 1;
    }         
  else
    {
      /* Success */
     if ( debug & DEBUG_AUTHEN_FLAG ) 
     		report(LOG_DEBUG, "LDAP authentication Sucess ");
     ldap_unbind_s(ld); 
     return 0;
    }
}
#endif /* LDAP */
