// Ce programme prsente les bases de la programmation Windows
// Notions :
//           - Cration de dialogues
//           - Gestionnaire d'vnements
//           - Creation de fentre
//           - Creation et utilisation d'une ressource
//           - Utilisation du GDI de Windows (Graphics Device Interface)
//           - Jouer des .WAV (sans DirectSound)
// Date    : 12/06/99
// Auteur  : Shaun Dor (dores@videotron.ca)


#include <windows.h>   // Le include de base de tout programme Windows
#include "resource.h"  // Le fichier ressource que Visual C a cre pour nous
#define MESSAGE "Voici une nouvelle fentre!" // Message contenu dans la fentre


HINSTANCE  hInst   = NULL;   // Variable pour contenir l'instance de notre programme
HWND	   hwnd    = NULL;   // Le 'handle' de notre fentre
WNDCLASS   fenetre;          // Notre objet fentre 

// Prototypes de fonctions

// Le gestionnaire d'vnements de notre fentre
LRESULT CALLBACK WindowProc(HWND hwnd,UINT msg,WPARAM wparam,LPARAM lparam);

// Le gestionnaire d'vnements de notre dialogue
LRESULT CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

// Fonctions

// Cette fonction va tout simplement crer une fentre avec les paramtres de la classe fentre
void CreeFenetre()
{
    // Si elle existe dj
    if (hwnd) 
	{
		// Affiche une bote de dialogue
		MessageBox(hwnd,"Vous ne pouvez pas crer plus qu'une fentre dans ce programme!",
			       "Erreur",MB_OK | MB_ICONEXCLAMATION);	
		return;
	}
	// Cration de la fentre et assignation de l'handle de la fentre
	hwnd = CreateWindow("Classe fenetre",				  // nom de la classe
						"Creation de fentre",            // titre de la fentre
						WS_OVERLAPPEDWINDOW | WS_VISIBLE, // apparence
						0,0,							  // x,y
						320,240,                          // largeur, hauteur
						NULL,	                          // handle a son parent 
						NULL,							  // handle a son menu
						hInst,                            // instance
						NULL);	                          // paramtres de cration
}


// Le gestionnaire d'vnements de fentres
// Nous grons ici tous les messages que nous voulons interprter
// Ceux qui ne seront pas trait par notre gestionnaire seront
// pris en charge par DefWindowProc, le gestionnaire par dfaut
LRESULT CALLBACK WindowProc(HWND hwnd,       // Handle de la fentre
						    UINT msg,        // message du systme
                            WPARAM wparam,   // paramtre supplmentaire 
                            LPARAM lparam)   // paramtre supplmentaire
{

	PAINTSTRUCT		ps;		// utiliser par l'vnement WM_PAINT
	HDC				hdc;	// handle sur un 'device context'

	// analyse des messages
	switch(msg)
	{	
	case WM_PAINT: 
		{
			hdc = BeginPaint(hwnd,&ps);
		    TextOut(hdc,70,90,MESSAGE,strlen(MESSAGE));
			EndPaint(hwnd,&ps);
         	return(0);
   		} break;

	default:break;

    } 

	// les messages que nous ne traitons pas sont dirigs par Window
	return (DefWindowProc(hwnd, msg, wparam, lparam));

} 

// Le gestionnaire d'vnements pour notre bote de dialogue
LRESULT CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)  
{
	switch(msg)
	{
		// Un bouton de commande (le # du bouton est contenu dans le low 8-bit de wParam)
		case WM_COMMAND: 
		{                                                       
			switch(LOWORD(wParam))
			{
				// Nouvelle fentre
				case ID_WIN:
					{
						CreeFenetre();     
						break; 
					}
				// Son .WAV
				case ID_SND:
					{
						PlaySound(MAKEINTRESOURCE(IDR_WAV),hInst,SND_RESOURCE | SND_ASYNC);
						break;
					}
				// Quitter
				case ID_QUIT: 
					{
						EndDialog(hwnd, FALSE);
						break;
					}
			}
			break;
		}
        default: 	
			return FALSE; 
     }
     return TRUE; 
}


// Procedure principale (Win)Main                                                                                                                         
int WINAPI WinMain(			
     HINSTANCE hInstance,	// handle sur l'instance prsente
     HINSTANCE hPrevInst,	// handle sur l'instance prcdente (Win 3.1, obsolte)
     LPSTR lpCmdLine,		// ptr sur la ligne de commande (ie: argv[], argc)
     int nCmdShow)			// l'tat de la fentre

{
	// dfinition des paramtre de la classe fentre
	fenetre.style			= CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	fenetre.lpfnWndProc		= WindowProc;
	fenetre.cbClsExtra		= 0;
	fenetre.cbWndExtra		= 0;
	fenetre.hInstance		= hInstance;
	fenetre.hIcon			= LoadIcon(NULL, IDI_EXCLAMATION);
	fenetre.hCursor			= LoadCursor(NULL, IDC_ARROW);
	fenetre.hbrBackground	= (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);
	fenetre.lpszMenuName	= NULL;
	fenetre.lpszClassName	= "Classe fenetre";

	// enregistrer la classe fentre
	if (!RegisterClass(&fenetre)) return(0);
     
	// sauvegarder l'instance de notre programme
	hInst = hInstance; 
	// Activer la bote de dialogue
    DialogBox(hInst, MAKEINTRESOURCE(IDD_MENU), NULL, ( DLGPROC ) DlgProc);
  
    return (0);
}
