#include <stdio.h>
#include <sys/time.h>
#include <rpc/rpc.h>
#include <rpcsvc/yp_prot.h>
#include "nhost.h"
#include "ypx-add.h"

#ifndef lint
static char *copyright = "@(#)ypx-func.c 2.2 92/05/08 Rob J. Nauta\n";
#endif
static struct timeval TIMEOUT = {25, 0};	/* total timeout */
extern char *programname, *ypdomain;

CLIENT *
rpc_yp_client(arg,thisport)
char *arg;
int thisport;
{
	char myhost[100];
	struct sockaddr_in *server_addr;
	int sock = RPC_ANYSOCK, klad = 0;
	CLIENT *client;

	if (gethostname(myhost, 100))	/* Get our own hostname */
		perror(programname);
	server_addr = getsock(arg);	/* Get adress info */
	if (server_addr == NULL)
		return (NULL);
	server_addr->sin_port = thisport;	/* Normally 0 (== portmapper)*/

	/*
	 * We use tcp, because receiving thousands of udp packets would slow
	 * down things considerably.
	 */
	if ((client = clnttcp_create(server_addr, YPPROG, YPVERS,
				     &sock, 0, 0)) == NULL) {
		clnt_pcreateerror(programname);
		return (NULL);	/* Failure */
	}
	client->cl_auth = authunix_create(myhost, 0, 0, 1, &klad);
	return (client);	/* Success */
}

static 
getmap(client, map, domain, outputfile)
CLIENT *client;
char *map, *domain;
FILE *outputfile;
{
	struct ypreq_nokey no;	/* To start lookup */
	struct ypreq_key key;	/* To continue lookup */
	enum clnt_stat re;
	static struct ypresp_key_val resp;	/* Results of lookup */
	char buffer[1024];

	resp.keydat.dptr = malloc(1024);
	resp.valdat.dptr = malloc(1024);
	no.domain = domain;	/* Startup values */
	no.map = map;
	/* Get the first entry */
	re = clnt_call(client, YPPROC_FIRST, xdr_ypreq_nokey, &no,
		       xdr_ypresp_key_val, &resp, TIMEOUT);
	if (re != RPC_SUCCESS) {
		clnt_perrno(re);
		return (2);
	}
	if (resp.status != 1)
		return (1);	/* Success, but no map, domainname wrong */
	while (resp.status == 1) {
		strncpy(buffer, resp.valdat.dptr, resp.valdat.dsize);
		buffer[resp.valdat.dsize] = (char) 0;
		fprintf(outputfile, "%s\n", buffer);

		key.domain = domain;
		key.map = map;
		key.keydat.dptr = resp.keydat.dptr;
		key.keydat.dsize = resp.keydat.dsize;

		/* Get next entry, using the previous one */
		re = clnt_call(client, YPPROC_NEXT, xdr_ypreq_key, &key,
			       xdr_ypresp_key_val, &resp, TIMEOUT);
		if (re != RPC_SUCCESS) {
			clnt_perrno(re);
			return (2);
		}
	}
	return (0);
}

/*
 * trymap - Tries the list of domainnames in table[] with getmap().
 */
trymap(client, mapname, debug, outputfile)
CLIENT *client;
char *mapname;
int debug;
FILE *outputfile;
{
	int teller = 0, res;
	while (teller < tablec) {
		if (debug)
			fprintf(stderr, "Trying domain %s\n", table[teller]);
		if ((res = getmap(client, mapname, table[teller], outputfile)
		     ) == 0) {
			ypdomain = table[teller];
			return (0);	/* success */
		}
		teller++;
	}
	return (res);		/* failure */
}
