//----------------------------------------------------------------------//
// FICHIER              : FXPLASMA.CPP                                  //
// AUTEUR       	    : Shaun Dore                                    //
// DESCRIPTION          : Plasma en temps reel                          //
// DATE DE MODIFICATION : 08-05-98                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include	                                                    //
//----------------------------------------------------------------------//

#include <math.h>
#include <conio.h>

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *screen = (char *) (0xA0000000L);

//----------------------------------------------------------------------//
// setpal - fixe les attributs r,g,b                                    //
//----------------------------------------------------------------------//
void setpal(unsigned char col, unsigned char r, unsigned char g, unsigned char b)
{
  outp (0x03C8,col);
  outp (0x03C9,r);
  outp (0x03C9,g);
  outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// preparepal - ajuste la palette a mon gout                            //
//----------------------------------------------------------------------//
void preparepal()
{
 for (int i=0;i<64;i++) setpal(i,i,0,0);
 for (i=64;i<128;i++)   setpal(i,0,i,0);
 for (i=128;i<196;i++)  setpal(i,0,0,i);
 for (i=196;i<256;i++)  setpal(i,0,0,i-196);
}


//----------------------------------------------------------------------//
// plasma - genere un plasma plein ecran en temps reel                  //
//----------------------------------------------------------------------//
void plasma()
{
  unsigned int  offset,cos1,cos2,cos3,cosinus[640];
  unsigned char col;
  cos1=cos2=cos3=0;

  for (int c=0;c<=640;c++) cosinus[c] = cos(2 * M_PI * c/320) * 32 + 32;
  do
  {
    offset = 0;
    cos1+=3; if (cos1 >=320) cos1 = 0;
    cos2+=4; if (cos2 >=320) cos2 = 0;
    cos3+=5; if (cos3 >=320) cos3 = 0;

    for (int y=0;y<200;y++)
      for (int x=0;x<320;x++)
	screen[offset++] = cosinus[x+cos2] +
			   cosinus[x+y]    +
			   cosinus[y+cos1] +
			   cosinus[y+cos3];
  } while (!kbhit());
}


//----------------------------------------------------------------------//
// Fonction principale                                                  //
//----------------------------------------------------------------------//
void main()
{
 asm {MOV AX, 0x13;INT 0x10}
 preparepal();
 plasma();
 asm {MOV AX, 0x03;INT 0x10}
}