//----------------------------------------------------------------------//
// FICHIER               : 2DCHAP7.CPP                                  //
// AUTEUR                : Shaun Dore                                   //
// DESCRIPTION           : Modes VESA hautes resolutions                //
// DATE DE MODIFICATION	 : 19-04-98                                     //
// COMPILATEUR           : Borland Turbo C++ Real Mode 16-bit compiler  //
// NOTES                 : Compiler avec modele memoire Compact         //
//----------------------------------------------------------------------//

#define PAUSE   asm {XOR AX,AX; INT 0x16}
#define TEXT    asm {MOV AX,0x03; INT 0x10}

//----------------------------------------------------------------------//
// Fichier includes                                                     //
//----------------------------------------------------------------------//

#include <mem.h>
#include <dos.h>
#include <stdio.h>

//----------------------------------------------------------------------//
// Structures de donnees                                                //
//----------------------------------------------------------------------//

typedef struct vesa                   // Information sur le pilote VESA
{
  unsigned char signature[4];
  unsigned char version1;
  unsigned char version2;
  char far *oem;
  long capabilities;
  unsigned far *videomodes;
  short memoire;
  char reserves[236];
};

typedef struct mode                   // Informations sur un mode VESA
{
  unsigned short AttributsMode;
  unsigned char  AttributsFenetreA;
  unsigned char  AttributsFenetreB;
  unsigned short GranulariteFenetre;
  unsigned short TailleFenetre;
  unsigned short SegmentFenetreA;
  unsigned short SegmentFenetreB;
  void far       *PtrFunctionFenetre;
  unsigned short OctetsParLigne;
  unsigned short ResolutionX;
  unsigned short ResolutionY;
  unsigned char  TailleCarX;
  unsigned char  TailleCarY;
  unsigned char  NombreDePlans;
  unsigned char  BitsParPixel;
  unsigned char  NbrBanques;
  unsigned char  ModeleMemoire;
  unsigned char  TailleBanque;
  unsigned char  NombrePages;
  unsigned char  Reserves[225];
};

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran;                   // Ptr sur segment initial de memoire video
char BanqueCur;                // Indicateur de la banque memoire courante
char decalage;                 // Decalage entre les fenetres
vesa *vesaInfo = (vesa *)256;  // Informations sur le pilote VESA
mode *modeInfo = (mode *)256;  // Information sur un mode VESA
struct REGPACK  Regs;          // Registres du processeur
unsigned short  Banques[15];   // Adresse des banques memoires
unsigned int nomode = 0x101;   // No du mode video


//----------------------------------------------------------------------//
// Fonction 0x00  - Lire les information sur le pilote VESA de la carte //
//----------------------------------------------------------------------//
void lireVesaInfo()
{
  Regs.r_ax = 0x4F00;
  Regs.r_es = FP_SEG(vesaInfo);
  Regs.r_di = FP_OFF(vesaInfo);
  intr (0x10, &Regs);
}

//----------------------------------------------------------------------//
// Fonction 01h - Determiner les donnes-cles d'un mode VESA             //
//----------------------------------------------------------------------//
void lireInfoMode(unsigned short Mode)
{
  Regs.r_ax = 0x4F01;
  Regs.r_cx = Mode;
  Regs.r_es = FP_SEG(modeInfo);
  Regs.r_di = FP_OFF(modeInfo);
  intr (0x10, &Regs);
}

//----------------------------------------------------------------------//
// Fonction 02h - Initialise un mode graphique VESA                     //
//----------------------------------------------------------------------//
void initVESAmode(unsigned short Mode)
{
  Regs.r_ax = 0x4F02;
  Regs.r_bx = Mode;
  intr (0x10, &Regs);
  lireInfoMode(Mode);

  int i = modeInfo->TailleFenetre/modeInfo->GranulariteFenetre;
  switch(i)
  {
   case 1:  decalage=0; break;
   case 2:  decalage=1; break;
   case 4:  decalage=2; break;
   case 8:  decalage=3; break;
   case 16: decalage=4; break;
   case 32: decalage=5; break;
   case 64: decalage=6; break;
  }
  for (int fenetre=0; fenetre<15; fenetre++)
    Banques[fenetre] = (fenetre * modeInfo->TailleFenetre/modeInfo->GranulariteFenetre);
  unsigned short Segment = modeInfo->SegmentFenetreA;
  ecran = (char *) MK_FP(Segment, 0x000);
}

//----------------------------------------------------------------------//
// Fonction 05h - Fonction pour changer de banque memoire               //
//----------------------------------------------------------------------//
void changerBanque(unsigned short Banque)
{
  BanqueCur = Banque;
  Regs.r_ax = 0x4F05;
  Regs.r_bx = decalage;
  Regs.r_dx = Banques[Banque];
  intr (0x10, &Regs);
}

//----------------------------------------------------------------------//
// Putpixel en modes VESA 256 couleurs                                  //
//----------------------------------------------------------------------//
void putpixel (long X, long Y, unsigned char Color)
{
  unsigned long  offset;
  unsigned short Banque;

  offset = (Y*modeInfo->ResolutionX) + X;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset] = Color;
}


//----------------------------------------------------------------------//
// Putpixel en modes VESA hicolor                                       //
//----------------------------------------------------------------------//
void putpixelH(int x, int y, int red, int green, int blue)
{
 unsigned long int offset;
 unsigned short Banque;
 int data;

 switch(nomode)
 {
 case 0x10D: // Couleurs 15-bit
 case 0x110:
 case 0x113:
 case 0x116:
 case 0x119:
  data = (red & 0xF8) << 7 | (green & 0xF8) << 2 | (blue & 0xF8) >> 3;
  offset = (long)y * modeInfo->OctetsParLigne + 2 * x;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset++] = data & 0xFF;
  ecran[offset] = data >> 8;
  break;
 case 0x10E: // Couleurs 16-bit
 case 0x111:
 case 0x114:
 case 0x117:
 case 0x11A:
  data = (red & 0xF8) << 8 | (green & 0xFC) << 3 | (blue & 0xF8) >> 3;
  offset = (long)y * modeInfo->OctetsParLigne + 2 * x;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset++] = data & 0xFF;
  ecran[offset] = data >> 8;
  break;
 case 0x10F: // Couleurs 24-bit
 case 0x112:
 case 0x115:
 case 0x118:
 case 0x11B:
  offset = (long)y * modeInfo->OctetsParLigne + 3 * x;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset++] = blue;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset++] = green;
  Banque = offset >> 16;
  if (BanqueCur != Banque) changerBanque(Banque);
  ecran[offset] = red;
 }
}


//----------------------------------------------------------------------//
// setpal - Modifie la palette                                          //
//----------------------------------------------------------------------//
void setpal(unsigned char coul,unsigned char r,unsigned char g,unsigned char b)
{
   outp (0x03C8,coul);
   outp (0x03C9,r);
   outp (0x03C9,g);
   outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// loadpcx - Charge en memoire un fichier .PCX                          //
//----------------------------------------------------------------------//
int loadpcx(char *nomfich)
{

  unsigned char data, nb_octets, palette[768];
  unsigned long index = 0;
  unsigned int  indexrle,x,y;
  unsigned short Bank = 0;
  FILE *fichpcx;

  if (!(fichpcx = fopen(nomfich, "rb"))) return 0;
  fseek(fichpcx, -768, SEEK_END);
  fread(&palette, 768, 1, fichpcx);
  for (int coul=0;coul<=255;coul++)
    setpal(coul,palette[coul*3]>>2,palette[coul*3+1]>>2,palette[coul*3+2]>>2);
  fseek(fichpcx, 128, SEEK_SET);
  do
  {
    fread(&data, 1, 1, fichpcx);
    if ((data & 0xC0) == 0xC0)
    {
	 nb_octets = (data & 0x3F);
	 fread(&data,1,1,fichpcx);
	 for (indexrle=0;indexrle<nb_octets;indexrle++)
	 {
	   Bank = index >> 16;
	   if (BanqueCur != Bank) changerBanque(Bank);
	   ecran[index++] = data;
	 }
    }
    else
    {
	   Bank = index >> 16;
	   if (BanqueCur != Bank) changerBanque(Bank);
	   ecran[index++] = data;
    }
  } while(index < 307200L);
  fclose(fichpcx);
  return 1;
}

//----------------------------------------------------------------------//
// Fonction principale                                                  //
//----------------------------------------------------------------------//
void main()
{
  TEXT
  lireVesaInfo();
  printf("* INFORMATIONS VESA *\n---------------------\n");
  printf("Version VESA : %i.%i\n",vesaInfo->version2,vesaInfo->version1);
  printf("Manufacturier: %s\n",vesaInfo->oem);
  printf("Memoire: %i Meg\n",vesaInfo->memoire >> 4);
  PAUSE


  // LoadPCX en 640x480x8 bit
  initVESAmode(nomode);
  if(!(loadpcx("ad.pcx")))
  {
    TEXT
    printf("ERREUR: Incapable de charger ad.pcx");
    return;
  }

  PAUSE

  // 640x480x15-bit
  nomode = 0x110;
  initVESAmode(nomode);
  for (int y=0;y<480;y++)
    for (int x=0;x<640;x++)
	putpixelH(x,y,0,x%100,x&y);
  PAUSE

  // 640x480x16-bit
  nomode = 0x111;
  initVESAmode(nomode);
  for (y=0;y<480;y++)
    for (x=0;x<640;x++)
	 putpixelH(x,y,0,x%100,x&y);
  PAUSE

  // 640x480x24-bit
  nomode = 0x112;
  initVESAmode(nomode);
  for (y=0;y<480;y++)
    for (x=0;x<640;x++)
	 putpixelH(x,y,0,x%100,x&y);
  PAUSE
  TEXT
  printf("\n* INFORMATIONS DU MODE *\n------------------------\n");
  printf("Granularite : %iK\n",modeInfo->GranulariteFenetre);
  printf("TailleFenetre : %iK\n",modeInfo->TailleFenetre);
  printf("Segment Fenetre: 0x%x\n",modeInfo->SegmentFenetreA);
  printf("Octets par ligne: %i\n",modeInfo->OctetsParLigne);
  printf("Resolution X: %i\n",modeInfo->ResolutionX);
  printf("Resolution Y: %i\n",modeInfo->ResolutionY);
  printf("Bits par pixel %i\n",modeInfo->BitsParPixel);
  printf("\nShaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun");
}
