//////////////////////////////////////////////////////////////////////////
// Code source  :    Shaun Dore                                         //
// Fichier      :    3DCHAP1.CPP                                        //
// Date         :    19-09-1998                                         //
// Compilateur  :    Borland C++ 3.0 16-bit Real Mode                   //
// Description  :    Representation de points 3D sur un ecran 2D        //
//////////////////////////////////////////////////////////////////////////

// ---------------------------  INCLUDE --------------------------------//

#include <mem.h>
#include <conio.h>
#include <stdlib.h>

// ---------------------- CONSTANTES & MACROS --------------------------//

#define DISTANCE     100             // Distance de l'observateur
#define MAX_ETOILES  1000            // Nombre d'etoiles
#define ZMIN         -100            // Valeur minimum de Z
#define ZMAX         -10             // Valeur maximum de Z
#define DX           160             // Distance X
#define DY           100             // Distance Y
#define DZ           (ZMAX-ZMIN)     // Distance Z

// -------------------  STRUCTURES DE DONNEES --------------------------//

// Structure pour representer un point dans un espace 2D
typedef struct _2D
{
   int x,y;
};

// Structure pour representer un point dans un espace 3D
typedef struct _3D
{
   int x,y,z;
};

//------------------------- VARIABLES GLOBALES --------------------------//

char *ecran   = (char *) (0xA0000000L);  // Pointeur sur memoire video
char *virtuel = new char[64000L];        // Pointeur sur ecran virtuel
_3D Etoiles [MAX_ETOILES];               // Coordonnees 3D des etoiles
_2D Ecran   [MAX_ETOILES];               // Coordonnees d'ecran 2D

//---------------------------- FONCTIONS --------------------------------//


void putpixel (int x, int y, unsigned char col)
{
  if ( (x>0) && (x<320) && (y>0) && (y<200) )
  virtuel[(y << 8) + (y << 6)+x] = col;
}

// Initialise une etoile avec des variables aleatoires
void PlaceEtoile(_3D *Vecteur, int z)
{
  Vecteur->x = random(DX)-DX/2;
  Vecteur->y = random(DY)-DY/2;
  Vecteur->z = z;
}

// Transforme les coordonnees 3D d'un point en coordonnees d'ecran
// par perspective a point de fuite X' = (X/Z), en tenant compte de
// la distance focale et avec translation vers le millieu de l'ecran
void Projection(_3D Vecteur,_2D *Ecran)
{
   Ecran->x = 160 + DISTANCE * Vecteur.x / Vecteur.z;
   Ecran->y = 100 + DISTANCE * Vecteur.y / Vecteur.z;
}


void main()
{
  int couleur;

  asm{MOV AX,0x13; INT 0x10}   // Mode graphique
  randomize();                 // Initialise nombre aleatoire

  // Initialise les etoiles
  for(int e=0; e<MAX_ETOILES; e++) PlaceEtoile(&Etoiles[e],(random(DZ)+ZMIN));

  do
  {
    for(e=0; e<MAX_ETOILES; e++)
    {
	 Etoiles[e].z++;           // Approche les etoiles
	 if(Etoiles[e].z>ZMAX) PlaceEtoile(&Etoiles[e],ZMIN);
    }

    for(e=0; e<MAX_ETOILES; e++)
    {
	 Projection(Etoiles[e],&Ecran[e]);  // Projection
	 putpixel(Ecran[e].x,Ecran[e].y,(Etoiles[e].z-ZMIN)*15/DZ+16 );
    }
  while(!(inp(0x3DA)&8));       // retrace verticale
  memcpy(ecran,virtuel,64000L); // copie le contenu sur l'ecran physique
  memset(virtuel,0,64000L);     // efface l'ecran virtuel

  } while (!kbhit());           // tant que !clavier
  asm{MOV AX,0x03; INT 0x10}     // Mode texte
}
