//----------------------------------------------------------------------//
// FICHIER : 2DCHAP5.CPP                                                //
// AUTEUR : Shaun Dore                                                  //
// DESCRIPTION : Charger une image .PCX et .BMP                         //
// DATE DE MODIFICATION	: 19-03-98                                      //
// COMPILATEUR : Borland Turbo C++ Real Mode 16-bit compiler            //
// NOTES : Compiler avec modele memoire Compact                         //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include                                                     //
//----------------------------------------------------------------------//

#include <mem.h>
#include <conio.h>
#include <stdio.h>

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran  = (char *) (0xA0000000L);

//----------------------------------------------------------------------//
// setmode - Appelle le mode passer en parametre                        //
//----------------------------------------------------------------------//
void setmode(unsigned int mode)
{
  asm {
	   MOV AX, mode
	   INT 0x10
      }
}

//----------------------------------------------------------------------//
// setpal - Modifie la palette                                          //
//----------------------------------------------------------------------//
void setpal(unsigned char coul,unsigned char r,unsigned char g,unsigned char b)
{
   outp (0x03C8,coul);
   outp (0x03C9,r);
   outp (0x03C9,g);
   outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// loadpcx - Charge en memoire un fichier .PCX                          //
//----------------------------------------------------------------------//
int loadpcx(char *nomfich,unsigned long taille,char *image)
{
  unsigned char data, nb_octets, palette[768];
  unsigned long index = 0;
  unsigned int  indexrle;
  FILE *fichpcx;

  if (!(fichpcx = fopen(nomfich, "rb"))) return 0;
  fseek(fichpcx, -768, SEEK_END);
  fread(&palette, 768, 1, fichpcx);
  for (int coul=0;coul<=255;coul++)
    setpal(coul,palette[coul*3]>>2,palette[coul*3+1]>>2,palette[coul*3+2]>>2);
  fseek(fichpcx, 128, SEEK_SET);

  do
  {
    fread(&data, 1, 1, fichpcx);
    if ((data & 0xC0) == 0xC0)
    {
      nb_octets = (data & 0x3F);
      fread(&data,1,1,fichpcx);
      for (indexrle=1;indexrle<=nb_octets;indexrle++) image[index++]=data;
    }
    else image[index++] = data;
  } while(index < taille);

  fclose(fichpcx);
  return 1;
}


//----------------------------------------------------------------------//
// loadbmp - Charge en memoire un fichier .BMP                          //
//----------------------------------------------------------------------//
int loadbmp(char *nomfich,int largeur,int hauteur,char *image)
{
  unsigned char palette[256][4];
  FILE *fichbmp;

  if(!(fichbmp = fopen(nomfich, "rb"))) return 0;
  fseek(fichbmp,54, SEEK_SET);
  fread(&palette, 1024, 1, fichbmp);
  for(int coul=0;coul<=255;coul++)
    setpal(coul,palette[coul][2]>>2,palette[coul][1]>>2,palette[coul][0]>>2);

  unsigned int offset = 64000;
  for (int ligne=0;ligne<hauteur;ligne++)
  {
    fread (image+offset,largeur,1,fichbmp);
    offset -= 320;
  }
  fclose (fichbmp);
  return 1;
}


//----------------------------------------------------------------------//
// Fonction MAIN                                                        //
//----------------------------------------------------------------------//

void main()
{
  char *fich1 = "babylon5.pcx";
  char *fich2 = "nuages.bmp";
  setmode(0x13);

  if (!(loadpcx(fich1,64000L,ecran)))
  {
    setmode(0x03);
    printf("ERREUR: incapable de charger %s!",fich1);
    return;
  }

  getch();
  memset(ecran,0,64000L);

  if (!(loadbmp(fich2,320,200,ecran)))
  {
    setmode(0x03);
    printf("ERREUR: incapable de charger %s!",fich2);
    return;
  }
  getch();
  setmode(0x03);
  printf("Shaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun");
}
