//--------------------------------------------------------------------------//
//                           T E X T  S C R O L L E R                       //
//                                                                          //
//                      code: Shaun Dore(dores@videotron.ca)                //
///--------------------------------------------------------------------------//

#include <mem.h>               // memset, memcpy
#include <stdio.h>             // fread, printf
#include <conio.h>             // getch, kbhit
#include <string.h>            // strlen

#define  LARGEUR   40          // largeur de la police
#define  HAUTEUR   40          // hauteur de la police
#define  VITESSE   4           // vitesse de deplacement

char *screen  = (char *) (0xA0000000L);    // Adresse de la memoire video
char *police  = (char *) (0xF000FA6EL);    // Adresse en ROM de la police
char *buffer  = new char[64000L];          // Ecran virtuel 320x200

// Message qui deroule sur l'ecran
unsigned char message[] = "  L'ARTISTE DIGITAL      PROGRAMMATION GRAPHIQUE 2D/3D/Assembleur     HTTP://PAGES.INFINIT.NET/SHAUN/       TUTEURS, CODE SOURCE ET PLUS!...    PRESENTE PAR KRASHLOG    DORES@VIDEOTRON.CA  ";

// Dessine un caractere
void dessinecar(int xpos, int ypos, int c, unsigned char coul)
{
  char far *car = &police[(c & 255) * 8]; // Obtient l'adresse du caractere
  unsigned char bit;                      // Utiliser pour masquer l'octet

  for (int y=0; y<HAUTEUR; y+=HAUTEUR/8)
  {
    if (y + ypos < 200)
    {
      bit = 0x80;
      for (int x=0; x<LARGEUR; x+=LARGEUR/8)
      {
	if ((x + xpos < 320) && (x + xpos > 0))
	  if (*car & bit) buffer[(y+ypos)*320+x+xpos] = coul;
	bit >>= 1;                // Si le bit est egal a 1, affiche le pixel
      }
    }
    coul++; // Incremente la couleur
    car++;  // Prochain octet du bitmap
  }
}


void texte(int y)
{
 int x=320;
 int longueur = -(strlen(message)) * LARGEUR;

 while(!(kbhit()))
 {
   if (x < longueur ) x = 320;
   x-=VITESSE;
   for (int i=0; message[i]; i++) dessinecar(x+(i*LARGEUR),y,message[i],22);
   while (inp(0x3da) & 8);
   while (!(inp(0x3da) & 8));
   memcpy(screen,buffer,64000L);
   memset(buffer,0,64000L);
 }
}


void main()
{
  asm{mov ax,0x13; int 0x10}    // Mode 13h 320x200x256 graphique
  texte(100-HAUTEUR/2);         // Texte defilant
  asm{mov ax,0x03; int 0x10}    // Mode 03h 80x25 texte
  delete[] buffer;              // Vide le buffer
}
