//--------------------------------------------------------------------------//
//                             D O T   T U N N E L                          //
//                                                                          //
//                      code: Shaun Dore(dores@videotron.ca)                //
//                      note: Modele memoire Compact                        //
//                                                                          //
//--------------------------------------------------------------------------//

#include <mem.h>             // memcpy, memset
#include <math.h>            // sin, cos
#include <conio.h>           // getch, kbhit
#include <stdio.h>           // printf

// J'avoue que je suis virer un peu malade avec les macros et les #defines
// mais j'ai tellement changer les parametres souvent que je me suis fatiguer
// de toujours les reecrires. Je ne garanti rien sur leur fonctionnement
// mais elle permette de changer dramatiquement l'appparence du tunnel.
// Utilisez-les a vos risques!

#define PRECISION     6      // Incrementeur d'angle dans le cercle
#define MOUV_X        3      // Incremente le mouvement du tunnel sur l'axe X
#define MOUV_Y        4      // Incremente le mouvement du tunnel sur l'axe Y
#define DENSITE       10     // Distance entre les cercles du tunnel
#define AMPLITUDE_X   60     // Amplitude du deplacement X
#define AMPLITUDE_Y   30     // Amplitude du deplacement Y
#define PROFONDEUR    200    // Profondeur du tunnel
#define ANGLE_MAX     360    // Angle du cercle
#define RESOLUTION_X  320    // Resolution horizontale
#define RESOLUTION_Y  200    // Resolution verticale
#define MILLIEU_X     RESOLUTION_X/2     // Centre de l'ecran X
#define MILLIEU_Y     RESOLUTION_Y/2     // Centre de l'ecran Y

// Pointeur sur memoire video
unsigned char far *screen = (char far*) (0xA0000000L);
// Pointeur sur memoire tampon d'ecran
unsigned char far *buffer = new unsigned char[RESOLUTION_X*RESOLUTION_Y];


float CosTable[ANGLE_MAX];   // Table des cosinus precalcule
float SinTable[ANGLE_MAX];   // Table des sinus precalcule
int   CosMouv[256];    // Table precaucule pour les mouvements du tunnel (X)
int   SinMouv[256];    // Table precalcule pour les mouvements du tunnel (Y)

// PreCalcul()
// Calcule les 4 tables pour acceler les calculs
//  - 2 tables pour le dessin du cercle (SinMouv et CosMouv)
//  - 2 tables pour le deplacement du tunnel (SinTable et CosTable)
void PreCalcul()
{
  // Le tunnel va se deplacer selon AMPLITUDE_X et AMPLITUDE_Y, soit entre
  // l'intervalle [-AMPLITUDE_X..AMPLITUDE_X], et la meme chose pour Y
  for(int i=0;i<256;i++)
  {
    CosMouv[i] = (cos(M_PI*i/128)*AMPLITUDE_X);
    SinMouv[i] = (sin(M_PI*i/128)*AMPLITUDE_Y);
  }
  // Cette table sert a dessiner les points sur un cercle de ANGLE_MAX deg
  // Pour chaque angle du cercle, 2*PI*angle/360 (360 = angle du cercle)
  for (i=0;i<ANGLE_MAX;i++)
  {
    CosTable[i] = (cos(2*M_PI*i/ANGLE_MAX));
    SinTable[i] = (sin(2*M_PI*i/ANGLE_MAX));
  }
}

// DessinePoint()
// Cette fonction dessine un point, dispose sur un cercle. On envoie l'angle
// le rayon et la couleur du point, et on utilise la formule du cercle:
//   - X = CentreX + Rayon * Cos(theta)
//   - Y = CentreY + Rayon * Sin(theta)
// Notre cercle comporte ANGLE_MAX degree.
void DessinePoint(unsigned int x_centre, unsigned int y_centre,
			   unsigned int rayon, unsigned int angle, unsigned char col)
{
  unsigned int x = MILLIEU_X+x_centre+(rayon*CosTable[angle]);
  unsigned int y = MILLIEU_Y+y_centre+(rayon*SinTable[angle]);

  if ((x<RESOLUTION_X) && (y<RESOLUTION_Y)) buffer[(y*RESOLUTION_X)+x] = col;
}

// Tunnel()
// Dessine une serie cercle, former par des points, de rayon croissant.
// Les cercles debutent avec un petit rayon qui augmente graduellement,
// ainsi que leur indice de couleur, a partir de 16 jusqu'a 31, un degrade
// de gris sur la palette VGA standard. Chaque cercle suit le deplacement
// prescrit par CosMouv et SinMouv, qui s'assure que le tunnel se deplacera
// de facon sinuosidale.
void Tunnel()
{
  char x = 0;              // Centre x du tunnel (-128..127)
  char y = 0;              // Centre y du tunnel (-128..127)
  unsigned int z;          // "Profondeur" du tunnel, aussi le rayon du cercle
  unsigned int angle;      // Compteur d'angle dans le cercle etant dessiner
  unsigned char inc_dist;  // Incrementeur de distance entre les cercles
  unsigned char col;       // Couleur d'un point

  do // Boucle principale
  {
    memset(buffer,0,64000L); // Vide le double buffer
    col = 16;                // La couleur de base est 16
    z = 30;                  // Prodonfeur initiale a 30 (rayon du cercle #1)
    inc_dist = 2;            // Les cercles sont espace de 2 au debut

    do                       // Boucle pour une frame
    {
	 angle=0; // Le cercle commence a etre dessine a 0 deg
	 do       // Boucle pour un cercle
	 {
	DessinePoint(CosMouv[(x+(PROFONDEUR-z))%256], // Dessine un point sur
			SinMouv[(y+(PROFONDEUR-z))%256],    // le cercle, a angle,
			z,angle,col);                       // et ramene les valeurs
			angle+=PRECISION;                   // entre 0..255  avec %
	 } while (angle < ANGLE_MAX);                 // tant que < ANGLE_MAX

      if (((z += inc_dist) % DENSITE) == 0) inc_dist++;
								   // Incremente la distance
      if ((++col)>31) col = 31;            // entre les cercles et
    } while (z<PROFONDEUR+20);             // la couleur tant que
								   // pas PROFONDEUR max
    x += MOUV_X;                           // Deplace le tunnel sur l'axe X
    y += MOUV_Y;                           // Deplace le tunnel sur l'axe Y
    while (!(inp(0x3DA) & 8));             // et le debut d'une autre!
    memcpy(screen,buffer,64000L);          // Copie le resulat sur l'ecran
  } while (!(kbhit()));                    // tant qu'une touche pas enfoncer
 delete[] buffer;                          // Efface le buffer de 64k
}

void main()
{
  asm{mov ax,0x13;int 0x10}     // Mode graphique
  PreCalcul();                  // Table precacule
  Tunnel();                     // Tunnel de points
  asm{mov ax,0x03;int 0x10}     // Retour au mode texte
}
