//////////////////////////////////////////////////////////////////////////
// Code source  :    Shaun Dore                                         //
// Fichier      :    3DCHAP2B.CPP                                       //
// Date         :    29-10-1998                                         //
// Compilateur  :    Borland C++ 3.1                                    //
// Description  :    Rotation 3D					                    //
//////////////////////////////////////////////////////////////////////////

// ---------------------------  INCLUDE --------------------------------//

#include <mem.h>
#include <math.h>
#include <conio.h>

// ---------------------- CONSTANTES & MACROS --------------------------//

#define MX        160                    // Millieu de l'abscisse
#define MY        100                    // Millieu de l'ordonnee
#define DISTANCE  200                    // Distances de l'objet
#define SIN(x)    SinTable[x]            // Macro SIN()
#define COS(x)    CosTable[x]            // Macro COS()

// -------------------  STRUCTURES DE DONNEES --------------------------//

// type matrice reelle de 4x4
typedef float _mat4x4[4][4];

// Structure pour representer un point dans un espace 2D
typedef struct _2D
{
  int x,y;
};

// Structure pour representer un point dans un espace 3D
typedef struct _3D
{
  float x,y,z;
};

// Structure pour represente un sommet
typedef struct _sommet
{
  _3D local;            // coordonnees locales
  _3D monde;            // coordonnees dans le monde
  _2D ecran;            // coordonnees d'ecran
};

// Structure pour contenir un objet
typedef struct _objet
{
  int nbsommet;         // nombre de sommets
  _sommet sommet[12];   // coordonnees des sommets
};


//------------------------- VARIABLES GLOBALES --------------------------//

// Utilise pour initialiser les coordonnes locales d'un objet de type cube
_3D Cube[8] = {
			{  1.0,  1.0,  1.0 },
			{ -1.0,  1.0,  1.0 },
			{ -1.0, -1.0,  1.0 },
			{  1.0, -1.0,  1.0 },
			{  1.0,  1.0, -1.0 },
			{ -1.0,  1.0, -1.0 },
			{ -1.0, -1.0, -1.0 },
			{  1.0, -1.0, -1.0 }
};

char  *ecran   = (char *) (0xA0000000L);  // Memoire video
char  *virtuel = new char[64000L];        // Ecran virtuel

float SinTable[360];                      // Table Sinus
float CosTable[360];                      // Table Cosinus

_mat4x4  matrice;                         // mat de transformation homogene
_mat4x4  m1, m2;                          // matrices temporaires

// ------------------------- FONCTIONS --------------------------------//

/////////////////////////////////////////////////////////////////////////
// putpixel - affiche un pixel sur l'ecran virtuel                     //
/////////////////////////////////////////////////////////////////////////
void putpixel (int x, int y, unsigned char col)
{
  virtuel[(y<<8)+(y<<6)+x] = col;
}

/////////////////////////////////////////////////////////////////////////
// precalc - Calcule le tableau de sinus/cosinus                       //
/////////////////////////////////////////////////////////////////////////
void precalc()
{
  for(int angle=0; angle<360; angle++)
  {
	 SinTable[angle]=sin(angle*M_PI/180.0);
	 CosTable[angle]=cos(angle*M_PI/180.0);
  }
}

/////////////////////////////////////////////////////////////////////////
// copie_matrice -  copie une matrice source vers matrice destination  //
/////////////////////////////////////////////////////////////////////////
void copie_matrice(_mat4x4 source, _mat4x4 dest)
{
  memcpy(dest,source,sizeof(_mat4x4));
}

/////////////////////////////////////////////////////////////////////////
// mult_matrice - multiplie 2 matrices et mets le resultat dans dest   //
/////////////////////////////////////////////////////////////////////////
void mult_matrice(_mat4x4 m1, _mat4x4 m2, _mat4x4 dest)
{
  for(short i=0;i<4;i++)
    for(short j=0;j<4;j++)
	 dest[i][j] = m1[i][0]*m2[0][j]+
			    m1[i][1]*m2[1][j]+
			    m1[i][2]*m2[2][j]+
			    m1[i][3]*m2[3][j];
}

/////////////////////////////////////////////////////////////////////////
// ident_matrice - construit une matrice identite                      //
/////////////////////////////////////////////////////////////////////////
void ident_matrice(_mat4x4 m)
{
    memset(m,NULL,sizeof(_mat4x4));   // 1  0  0  0
    m[0][0] = 1.0;                    // 0  1  0  0
    m[1][1] = 1.0;                    // 0  0  1  0
    m[2][2] = 1.0;                    // 0  0  0  1
    m[3][3] = 1.0;                    // matrice identite
}

/////////////////////////////////////////////////////////////////////////
// echelle - matrice de changement d'echelle                           //
/////////////////////////////////////////////////////////////////////////
void echelle(_mat4x4 m,float ex,float ey, float ez)
{
   _mat4x4 emat;                      // matrice echelle

   ident_matrice(emat);               // initialise matrice identite
   emat[0][0]=ex;                     // ex 0  0  0
   emat[1][1]=ey;                     // 0  ey 0  0
   emat[2][2]=ez;                     // 0  0  ez 0
							   // 0  0  0  1
   mult_matrice(m,emat,m1);           // (emat X m) -> m1
   copie_matrice(m1,m);               // copie le resultat dans matrice
}                                     // globale de transformation homogene

/////////////////////////////////////////////////////////////////////////
// translation - matrice de translation                                //
/////////////////////////////////////////////////////////////////////////
void translation(_mat4x4 m,float tx,float ty,float tz)
{
   _mat4x4 tmat;                      // matrice translation

   ident_matrice(tmat);               // initialise matrice identite
   tmat[3][0]=tx;                     // 1  0  0  0
   tmat[3][1]=ty;                     // 0  1  0  0
   tmat[3][2]=tz;                     // 0  0  1  0
							   // tx ty tz 1
   mult_matrice(m,tmat,m1);           // (tmat X m) -> m1
   copie_matrice(m1,m);               // copie le resultat dans matrice
}                                     // globale de transformation homogene


/////////////////////////////////////////////////////////////////////////
// rotation - matrices de rotations                                    //
/////////////////////////////////////////////////////////////////////////
void rotation(_mat4x4 m,int ax,int ay,int az)
{
  _mat4x4 xmat, ymat, zmat;

  ident_matrice(xmat);
  ident_matrice(ymat);
  ident_matrice(zmat);

  xmat[1][1] =  COS(ax);  xmat[1][2] = SIN(ax);
  xmat[2][1] = -SIN(ax);  xmat[2][2] = COS(ax);

  ymat[0][0] =  COS(ay);  ymat[0][2] = -SIN(ay);
  ymat[2][0] =  SIN(ay);  ymat[2][2] =  COS(ay);

  zmat[0][0] =  COS(az);  zmat[0][1] =  SIN(az);
  zmat[1][0] = -SIN(az);  zmat[1][1] =  COS(az);

  mult_matrice(m,ymat,m1);
  mult_matrice(m1,xmat,m2);
  mult_matrice(m2,zmat,m);
}

/////////////////////////////////////////////////////////////////////////
// projection - transformation 3D -> 2D                                //
/////////////////////////////////////////////////////////////////////////
void projection(_sommet *sommet)
{
   sommet->ecran.x = sommet->monde.x * DISTANCE / sommet->monde.z + MX;
   sommet->ecran.y = sommet->monde.y * DISTANCE / sommet->monde.z + MY;
}

/////////////////////////////////////////////////////////////////////////
// transformation - multiplication de chaque sommet par la matrice     //
/////////////////////////////////////////////////////////////////////////
void transformation(_objet *object, _mat4x4 m)
{
   int v;
   _sommet *sommet;

   for(v=0; v<object->nbsommet; v++)
   {
	 sommet = &object->sommet[v];

	 sommet->monde.x = sommet->local.x*m[0][0]+
				       sommet->local.y*m[1][0]+
				       sommet->local.z*m[2][0]+
					                   m[3][0];

	 sommet->monde.y = sommet->local.x*m[0][1]+
				       sommet->local.y*m[1][1]+
				       sommet->local.z*m[2][1]+
					                   m[3][1];

	 sommet->monde.z = sommet->local.x*m[0][2]+
				       sommet->local.y*m[1][2]+
				       sommet->local.z*m[2][2]+
						               m[3][2];
	 projection(sommet);
   }
}

/////////////////////////////////////////////////////////////////////////
// Initialisation des sommets de l'objet                               //
/////////////////////////////////////////////////////////////////////////
void initialise_objet(_objet *objet)
{
  objet->nbsommet=8;
  for (int i=0;i<objet->nbsommet;i++)
  {
    objet->sommet[i].local.x=Cube[i].x;
    objet->sommet[i].local.y=Cube[i].y;
    objet->sommet[i].local.z=Cube[i].z;
  }

}

/////////////////////////////////////////////////////////////////////////
// dessine_objet - dessine les sommets de l'objet                      //
/////////////////////////////////////////////////////////////////////////
void dessine_objet(_objet *objet)
{
  for(int i=0;i<objet->nbsommet;i++)
   putpixel(objet->sommet[i].ecran.x, objet->sommet[i].ecran.y, 31);
}

//------------------------ FONCTION PRINCIPALE -------------------------//


void main(void)
{
  int angle=0;
  _objet cube;

  asm {MOV AX,0x13; INT 0x10}
  precalc();
  initialise_objet(&cube);

  while(!kbhit())
  {
    memset(virtuel,0,64000L);

    ident_matrice(matrice);
    echelle(matrice,20,20,20);
    rotation(matrice,angle,angle,angle);
    translation(matrice,0,0,-100);

    transformation(&cube,matrice);
    dessine_objet(&cube);

    while(!(inp(0x3DA)&8));
    memcpy(ecran,virtuel,64000L);
    if (angle++ == 359) angle = 0;
  };

  delete []virtuel;
  asm {MOV AX,0x03; INT 0x10}
}
