//----------------------------------------------------------------------//
// FICHIER               : 2DCHAP3.CPP                                  //
// AUTEUR                : Shaun Dore                                   //
// DESCRIPTION           : La palette VGA 8-bit                         //
// DATE DE MODIFICATION	: 10-01-98	                                //
// COMPILATEUR           : Borland Turbo C++ Real Mode 16-bit compiler  //
// NOTES                 : Compiler avec modele memoire Compact         //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include                                                     //
//----------------------------------------------------------------------//

#include <mem.h>
#include <conio.h>
#include <stdio.h>

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran = (char *) (0xA0000000L);   // Pointeur sur RAM video

//----------------------------------------------------------------------//
// setmode - Appelle le mode passer en parametre                        //
//----------------------------------------------------------------------//
void setmode(unsigned int mode)
{
 asm {
	  MOV AX, [mode]
       INT 0x10
     }
}

//----------------------------------------------------------------------//
// cls - vide l'ecran                                                   //
//----------------------------------------------------------------------//
void cls()
{
  memset(ecran,0,64000L);
}

//----------------------------------------------------------------------//
// putpixel - Affiche un pixel directement dans la memoire              //
//----------------------------------------------------------------------//
void putpixel(int x, int y, unsigned char coul)
{
  ecran[(y*320)+x] = coul;
}


//----------------------------------------------------------------------//
// syncretrace - attend un retour de balayage vertical                  //
//----------------------------------------------------------------------//
void syncretrace()
{
  while   (inp(0x3DA) & 8);  // Attend la fin d'une retrace verticale
  while (!(inp(0x3DA) & 8)); // ainsi que le debut d'une autre
}



//----------------------------------------------------------------------//
// setpal - fixe les attributs r,g,b                                    //
//----------------------------------------------------------------------//
void setpal(unsigned char coul,unsigned char r,unsigned char g,unsigned char b)
{
  outp(0x03C8,coul); // Envoie les informations au DAC
  outp(0x03C9,r);
  outp(0x03C9,g);
  outp(0x03C9,b);
}


//----------------------------------------------------------------------//
// lirepal - Lit les informations sur les attributs r,g,b               //
//----------------------------------------------------------------------//
void lirepal(unsigned char coul,unsigned char &r,unsigned char &g,unsigned char &b)
{
  outp   (0x03C7, coul); // Recoit les informations du DAC
  r = inp(0x03C9);
  g = inp(0x03C9);
  b = inp(0x03C9);
}

//----------------------------------------------------------------------//
// fadeto - Transforme la palette courante selon les attributs de pal   //
//----------------------------------------------------------------------//
void fadeto(unsigned char pal[256][3])
{
  unsigned char r,g,b;
  int terminer = 0;                 // Flag pour determiner la fin

  while (!(terminer))               // Avons-nous terminer?
  {
    terminer = 1;
    syncretrace();
    for (int coul=0;coul<256;coul++)// Parcourir les 256 couleurs
    {
      lirepal(coul,r,g,b);          // Lire les attributs de la couleur

      if (r > pal[coul][0])         // Traiter le cas du rouge
      {
	r--;                        // Si plus grand
	terminer=0;
      }
      else if (r < pal[coul][0])
      {
	r++;                        // Si plus petit
	terminer=0;
      }

      if (g > pal[coul][1])         // Traiter le cas du vert
      {
	g--;
	terminer=0;
      }
      else if (g < pal[coul][1])
      {
	g++;
	terminer=0;
      }

      if (b > pal[coul][2])         // Traiter le cas du bleu
      {
	b--;
	terminer=0;
      }
      else if (b < pal[coul][2])
      {
	b++;
	terminer=0;
      }
      setpal(coul,r,g,b);           // Modifier la palette
    }
  }
}

//----------------------------------------------------------------------//
// preparepal - Initialise notre palette de couleur                     //
//----------------------------------------------------------------------//
void preparepal()
{
  for(int coul=1;coul<65;coul++) setpal(coul,coul,0,0);      // Rouge
  for(coul=65;coul<130;coul++)   setpal(coul,0,coul,0);      // Vert
  for(coul=130;coul<195;coul++)  setpal(coul,0,0,coul);      // Bleu
}


//----------------------------------------------------------------------//
// barreRGB - Rempli l'ecran avec des barres de degrade de rgb          //
//----------------------------------------------------------------------//
void barreRGB()
{
  for(short y=0;y<195;y++)
    for(short x=0;x<319;x++)
      putpixel(x,y,y);
}

//----------------------------------------------------------------------//
// rotationpal - Modifie tour a tour chacunes des couleurs des barres   //
//----------------------------------------------------------------------//
void rotationpal()
{
  unsigned char r,g,b;
  do
  {
    for(unsigned char rgb=0;rgb<64;rgb++)
    {
      for (unsigned int ralenti=0;ralenti<16000;ralenti++) {}
      lirepal(rgb+1,r,g,b);
      setpal(rgb+1,r+1,0,0);    // Augmente le rouge
      lirepal(rgb+64,r,g,b);
      setpal(rgb+64,0,g+1,0);   // Augmente le vert
      lirepal(rgb+128,r,g,b);
      setpal(rgb+128,0,0,b+1);  // Augmente le bleu
    }
  } while (!kbhit());
}


//----------------------------------------------------------------------//
// scanbarres - Pour chaque couleur, change sa valeur a violette        //
//----------------------------------------------------------------------//
void scanbarres()
{
  unsigned char temp[3];        // Pour sauvegarder la couleur precedente
  unsigned char paltmp[256][3]; // Pour sauvegarder la palette initiale
  unsigned char palnoir[256][3];
  int y=2,dir=1;

  for (int i=0; i<256;i++)
  {
    palnoir[i][0] = 0; palnoir[i][1] = 0; palnoir[i][2]=0;
    lirepal(i,paltmp[i][0], paltmp[i][1], paltmp[i][2]);
    setpal(i,0,0,0);
  }

  barreRGB();      // Dessine nos barres rouge verte & bleue (en noir!)
  fadeto(paltmp);

  do
  {
    if (y==195)	dir = -1;                   // On repart vers le haut
    if (y==2)	dir = 1;                    // On repart vers le bas!
    y+=dir;        		            // Deplace la ligne mauve
    syncretrace(); 			    // Attend retrace verticale
    lirepal(y,temp[0], temp[1], temp[2]);   // Sauvegarde la couleur
    setpal(y-dir,temp[0],temp[1],temp[2]);  // Restore la couleur precedente
    setpal(y,30,0,50);                      // Modifie la couleur a violet

  } while (!kbhit());

  fadeto(palnoir);                          // Petit fade-out!
  for(i=0;i<256;i++) setpal(i,paltmp[i][0],paltmp[i][1],paltmp[i][2]);
  getch();                                  // On ramene la palette originale
  rotationpal();
  for(i=0;i<256;i++) setpal(i,paltmp[i][0],paltmp[i][1],paltmp[i][2]);
}

//----------------------------------------------------------------------//
// retrace - Utilite de la fonction syncretrace                         //
//----------------------------------------------------------------------//
void retrace()
{
  unsigned char r,g,b;

  for(unsigned char x=130;x<190;x++)
   for(unsigned char y=0;y<200;y++)
    putpixel(x,y,x);

  setpal(7,60,60,60);

  gotoxy(1,1);printf("Test de rotation");
  gotoxy(4,2);printf("de palette");
  gotoxy(1,8);printf("Avec syncretrace");
  getch();

  do
  {
    syncretrace();
    for(x=130;x<190;x++)
    {
      lirepal(x,r,g,b);
      setpal(x,0,0,b+1);
    }
  } while (!kbhit());
  getch();
  gotoxy(1,8);printf("Sans syncretrace");

  do
  {
    for(x=130;x<190;x++)
    {
      lirepal(x,r,g,b);
      setpal(x,0,0,b+1);
    }
  } while (!kbhit());

}

//----------------------------------------------------------------------//
// Fonction MAIN                                                        //
//----------------------------------------------------------------------//

void main()
{
  setmode(0x13);
  gotoxy(5,12);printf("<Appuyez sur RETOUR pour debuter>");getch();
  preparepal();
  scanbarres(); // Animation par changement de couleurs
  cls();
  getch();
  retrace();    // Demonstration de syncretrace()

  setmode(0x03);
  printf("Shaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun");
}


