//////////////////////////////////////////////////////////////////////////
// Code source  :    Shaun Dore                                         //
// Fichier      :    3DCHAP2A.CPP                                       //
// Date         :    29-09-1998                                         //
// Compilateur  :    Borland C++ 3.1                                    //
// Description  :    Rotation 3D					                 //
//////////////////////////////////////////////////////////////////////////

// ---------------------------  INCLUDE --------------------------------//

#include <mem.h>
#include <math.h>
#include <conio.h>

// ---------------------- CONSTANTES & MACROS --------------------------//

#define MX        160                    // Millieu de l'abscisse
#define MY        100                    // Millieu de l'ordonnee
#define DISTANCE  200                    // Distances de l'objet
#define MAX_POLY  100                    // Nb max de polygones
#define MAX_SOMM  100                    // Nb max de sommets
#define SIN(x)    SinTable[x]            // Macro SIN()
#define COS(x)    CosTable[x]            // Macro COS()

// -------------------  STRUCTURES DE DONNEES --------------------------//

// type matrice reelle de 4x4
typedef float _mat4x4[4][4];

// Structure pour representer un point dans un espace 2D
typedef struct _2D
{
  int x,y;
};

// Structure pour representer un point dans un espace 3D
typedef struct _3D
{
  float x,y,z;
};

// Structure pour represente un sommet
typedef struct _sommet
{
  _3D local;            // coordonnees locales
  _3D monde;            // coordonnees dans le monde
  _2D ecran;            // coordonnees d'ecran
};

// Structure pour representer une surface quadrilatere
typedef struct _quad
{
  short a,b,c,d;
};

// Structure pour contenir un objet
typedef struct _objet
{
  int nbsommet;         // nombre de sommets
  int nbpolygone;       // nombre de polygone
  _sommet sommet[MAX_SOMM];  // coordonnees des sommets
  _quad poly[MAX_POLY];      // polygone
};

typedef struct TScan         // Structure pour le remplissage de polygones
{
  long gauche,droite;
};


//------------------------- VARIABLES GLOBALES --------------------------//

// Utilise pour initialiser les coordonnes locales d'un objet de type cube
_3D Cube[8] = {
			 {-1.0, -1.0, -1.0},
			 {-1.0,  1.0, -1.0},
			 { 1.0,  1.0, -1.0},
			 { 1.0, -1.0, -1.0},
			 {-1.0, -1.0,  1.0},
			 {-1.0,  1.0,  1.0},
			 { 1.0,  1.0,  1.0},
			 { 1.0, -1.0,  1.0}
};

_quad faces[6] = {
			   {0,1,2,3},
			   {7,6,5,4},
			   {4,5,1,0},
			   {6,7,3,2},
			   {3,7,4,0},
			   {5,6,2,1}
};

float SinTable[360];                        // Table Sinus
float CosTable[360];                        // Table Cosinus
_mat4x4  matrice;                              // mat de transformation homogene
_mat4x4  mat1, mat2;                           // matrices temporaires
TScan scanline[200];                        // Largeur des lignes des polys
char  *ecran   = (char *) (0xA0000000L);    // Memoire video
char  *virtuel = new char[64000L];          // Ecran virtuel
unsigned int miny,maxy;

// ------------------------- FONCTIONS --------------------------------//

//----------------------------------------------------------------------//
// hline - Dessine une ligne horizontale                                //
//----------------------------------------------------------------------//
void hline(int x1, int x2, int y, unsigned char coul)
{
  memset(virtuel+x1+(y<<8)+(y<<6),coul,(x2-x1));
}

//----------------------------------------------------------------------//
// Swap - Effectue l'echange entre 2 variables float                    //
//----------------------------------------------------------------------//
void Swap(float &x,float &y)
{
  float temp = x;
	   x = y;
	   y = temp;
}

//----------------------------------------------------------------------//
// Scan - Trouve le minX et maxX d'un cote d'un polygone                //
//----------------------------------------------------------------------//
void scan(float x1, float y1, float x2, float y2)
{
  if (y1==y2) return;                        // Check pour la div/0
  if (y2<y1)  {Swap (y1,y2); Swap (x1,x2);}  // Dans le bon sens...

  double Xinc = (x2-x1) / (y2-y1);           // Regression lineaire
  double x = x1 += Xinc;                     // pente m = (dx/dy)
									// on saute par dessus le premier
  if(y1<miny) miny=y1;    	               // pixel
  if(y2>maxy) maxy=y2;

  for (int y=y1;y<y2;y++)                    // On scan la ligne de haut en bas
  {
    if (x < scanline[y].gauche) scanline[y].gauche = x;
    if (x > scanline[y].droite) scanline[y].droite = x;
    x+=Xinc;
  }
}

//----------------------------------------------------------------------//
// dessinepoly - Dessine un polygone avec liste de points(listesommet)  //
//----------------------------------------------------------------------//
void dessine_poly(_2D *listesommet, int nbcotes, unsigned char coul)
{
  _2D *ptrcour = listesommet;
  _2D *ptrsuiv = listesommet+1;

  miny=200; maxy=0;
  for (int i=0;i<200;i++)
  {
   scanline[i].gauche = 32000;
   scanline[i].droite = -32000;
  }
  for (i = 1; i < nbcotes; i++)
  {
    scan(ptrcour->x, ptrcour->y, ptrsuiv->x, ptrsuiv->y);
    ptrcour++;
    ptrsuiv++;
  }
  ptrsuiv = listesommet;
  scan(ptrcour->x, ptrcour->y, ptrsuiv->x, ptrsuiv->y);
  for (int y=miny;y<maxy;y++)
    hline(scanline[y].gauche,scanline[y].droite,y,coul);
}

/////////////////////////////////////////////////////////////////////////
// precalc - Calcule le tableau de sinus/cosinus                       //
/////////////////////////////////////////////////////////////////////////
void precalc()
{
  for(int angle=0; angle<360; angle++)
  {
	 SinTable[angle]=sin(angle*M_PI/180.0);
	 CosTable[angle]=cos(angle*M_PI/180.0);
  }
}

/////////////////////////////////////////////////////////////////////////
// copie_matrice -  copie une matrice source vers matrice destination  //
/////////////////////////////////////////////////////////////////////////
void copie_matrice(_mat4x4 source, _mat4x4 dest)
{
  memcpy(dest,source,sizeof(_mat4x4));
}

/////////////////////////////////////////////////////////////////////////
// mult_matrice - multiplie 2 matrices et mets le resultat dans dest   //            //
/////////////////////////////////////////////////////////////////////////
void mult_matrice(_mat4x4 m1, _mat4x4 m2, _mat4x4 dest)
{
  for(short i=0;i<4;i++)
    for(short j=0;j<4;j++)
	 dest[i][j]=
	 m1[i][0]*m2[0][j]+
	 m1[i][1]*m2[1][j]+
	 m1[i][2]*m2[2][j]+
	 m1[i][3]*m2[3][j];
}

/////////////////////////////////////////////////////////////////////////
// ident_matrice - construit une matrice identite                      //
/////////////////////////////////////////////////////////////////////////
void ident_matrice(_mat4x4 m)
{
    memset(m,NULL,sizeof(_mat4x4));
    m[0][0] = 1.0;
    m[1][1] = 1.0;
    m[2][2] = 1.0;
    m[3][3] = 1.0;
}

/////////////////////////////////////////////////////////////////////////
// echelle - matrice de changement d'echelle                           //
/////////////////////////////////////////////////////////////////////////
void echelle(_mat4x4 m,float ex,float ey, float ez)
{
   _mat4x4 emat;

   ident_matrice(emat);
   emat[0][0]=ex;
   emat[1][1]=ey;
   emat[2][2]=ez;

   mult_matrice(m,emat,mat1);
   copie_matrice(mat1,m);
}

/////////////////////////////////////////////////////////////////////////
// translation - matrice de translation                                //
/////////////////////////////////////////////////////////////////////////
void translation(_mat4x4 m,float tx,float ty,float tz)
{
   _mat4x4 tmat;

   ident_matrice(tmat);
   tmat[3][0]=tx;
   tmat[3][1]=ty;
   tmat[3][2]=tz;

   mult_matrice(m,tmat,mat1);
   copie_matrice(mat1,m);
}


/////////////////////////////////////////////////////////////////////////
// rotation - matrice de rotation                                      //
/////////////////////////////////////////////////////////////////////////
void rotation(_mat4x4 m,int ax,int ay,int az)
{
  _mat4x4 xmat, ymat, zmat;

  ident_matrice(xmat);
  ident_matrice(ymat);
  ident_matrice(zmat);

  xmat[1][1] =  COS(ax);  xmat[1][2] = SIN(ax);
  xmat[2][1] = -SIN(ax);  xmat[2][2] = COS(ax);

  ymat[0][0] =  COS(ay);  ymat[0][2] = -SIN(ay);
  ymat[2][0] =  SIN(ay);  ymat[2][2] =  COS(ay);

  zmat[0][0] =  COS(az);  zmat[0][1] =  SIN(az);
  zmat[1][0] = -SIN(az);  zmat[1][1] =  COS(az);

  mult_matrice(m,ymat,mat1);
  mult_matrice(mat1,xmat,mat2);
  mult_matrice(mat2,zmat,m);
}

/////////////////////////////////////////////////////////////////////////
// projection - transformation 3D -> 2D                                //
/////////////////////////////////////////////////////////////////////////
void projection(_sommet *sommet)
{
   if(!sommet->monde.z) sommet->monde.z=1;
   sommet->ecran.x = MX + sommet->monde.x * (DISTANCE / sommet->monde.z);
   sommet->ecran.y = MY + sommet->monde.y * (DISTANCE / sommet->monde.z);
}

/////////////////////////////////////////////////////////////////////////
// transformation - multiplication de chaque sommet par la matrice     //
/////////////////////////////////////////////////////////////////////////
void transformation(_objet *object, _mat4x4 m)
{
   int v;
   _sommet *sommet;

   for(v=0; v<object->nbsommet; v++)
   {
	 sommet = &object->sommet[v];

	 sommet->monde.x = sommet->local.x*m[0][0]+
				    sommet->local.y*m[1][0]+
				    sommet->local.z*m[2][0]+
								m[3][0];

	 sommet->monde.y = sommet->local.x*m[0][1]+
				    sommet->local.y*m[1][1]+
				    sommet->local.z*m[2][1]+
								m[3][1];

	 sommet->monde.z = sommet->local.x*m[0][2]+
				    sommet->local.y*m[1][2]+
				    sommet->local.z*m[2][2]+
								m[3][2];
	 projection(sommet);
   }
}

/////////////////////////////////////////////////////////////////////////
// Initialisation des sommets de l'objet                               //
/////////////////////////////////////////////////////////////////////////
void initialise_objet(_objet *objet)
{
  objet->nbsommet=8;
  objet->nbpolygone=6;
  for (int i=0;i<objet->nbsommet;i++)
  {
    objet->sommet[i].local.x=Cube[i].x;
    objet->sommet[i].local.y=Cube[i].y;
    objet->sommet[i].local.z=Cube[i].z;
  }
  for (i=0;i<objet->nbpolygone;i++)
  {
    objet->poly[i].a = faces[i].a;
    objet->poly[i].b = faces[i].b;
    objet->poly[i].c = faces[i].c;
    objet->poly[i].d = faces[i].d;
  }
}

/////////////////////////////////////////////////////////////////////////
// dessine_objet - dessine les sommets de l'objet                      //
/////////////////////////////////////////////////////////////////////////
void dessine_objet(_objet *objet)
{
  _2D poly[4];
  int normal;

  for (int f=0; f<6; f++)
  {
    poly[0] = objet->sommet[objet->poly[f].a].ecran;
    poly[1] = objet->sommet[objet->poly[f].b].ecran;
    poly[2] = objet->sommet[objet->poly[f].c].ecran;
    poly[3] = objet->sommet[objet->poly[f].d].ecran;

    normal = (poly[0].y - poly[2].y) *
		   (poly[1].x - poly[0].x) -
		   (poly[0].x - poly[2].x) *
		   (poly[1].y - poly[0].y);

   if (normal<0) dessine_poly(poly,4,21+f);
  }
}

//------------------------ FONCTION PRINCIPALE --------------------------//


void main(void)
{
  int angle=0;
  _objet cube;

  asm {MOV AX,0x13; INT 0x10}
  precalc();
  initialise_objet(&cube);

  while(!kbhit())
  {
    memset(virtuel,0,64000L);

    ident_matrice(matrice);
    echelle(matrice,20,20,20);
    rotation(matrice,angle,angle,angle);
    translation(matrice,0,0,-100);

    transformation(&cube,matrice);
    dessine_objet(&cube);
    while(!(inp(0x3DA)&8));
    memcpy(ecran,virtuel,64000L);
    if (angle++ == 359) angle = 0;
  };

  delete []virtuel;
  asm {MOV AX,0x03; INT 0x10}
}
