//////////////////////////////////////////////////////////////////////////
// Code source  :    Shaun Dore                                         //
// Fichier      :    3DCHAP2A.CPP                                       //
// Date         :    29-09-1998                                         //
// Compilateur  :    Borland C++ 3.1                                    //
// Description  :    Rotation 3D					                 //
//////////////////////////////////////////////////////////////////////////

// ---------------------------  INCLUDE --------------------------------//

#include <mem.h>
#include <math.h>
#include <conio.h>

// ---------------------- CONSTANTES & MACROS --------------------------//

#define MX        160                    // Millieu de l'abscisse
#define MY        100                    // Millieu de l'ordonnee
#define DISTANCE  200                    // Distances de l'objet
#define SIN(x)    SinTable[x]            // Macro SIN()
#define COS(x)    CosTable[x]            // Macro COS()

// -------------------  STRUCTURES DE DONNEES --------------------------//

// type matrice reelle de 4x4
typedef float _mat[4][4];

// Structure pour representer un point dans un espace 2D
typedef struct _2D
{
  int x,y;
};

// Structure pour representer un point dans un espace 3D
typedef struct _3D
{
  float x,y,z;
};

// Structure pour represente un sommet
typedef struct _sommet
{
  _3D local;            // coordonnees locales
  _3D monde;            // coordonnees dans le monde
  _2D ecran;            // coordonnees d'ecran
};

// Structure pour contenir un objet
typedef struct _objet
{
  int nbsommet;         // nombre de sommets
  _sommet sommet[100];  // coordonnees des sommets
  int nbligne;          // nombre de lignes
  _2D ligne[100];       // couples de lignes
};


//------------------------- VARIABLES GLOBALES --------------------------//

// Utilise pour initialiser les coordonnes locales d'un objet de type cube
_3D Cube[8] = {
			{  1.0,  1.0,  1.0 },
			{ -1.0,  1.0,  1.0 },
			{ -1.0, -1.0,  1.0 },
			{  1.0, -1.0,  1.0 },
			{  1.0,  1.0, -1.0 },
			{ -1.0,  1.0, -1.0 },
			{ -1.0, -1.0, -1.0 },
			{  1.0, -1.0, -1.0 }
};

_2D Ligne[12]={
		   {0,1},{1,2},{2,3},{3,0},
		   {4,5},{5,6},{6,7},{7,4},
		   {0,4},{1,5},{2,6},{3,7}
};

float SinTable[360];                        // Table Sinus
float CosTable[360];                        // Table Cosinus
_mat  matrice;                              // mat de transformation homogene
_mat  mat1, mat2;                           // matrices temporaires

char  *ecran   = (char *) (0xA0000000L);    // Memoire video
char  *virtuel = new char[64000L];          // Ecran virtuel

// ------------------------- FONCTIONS --------------------------------//


void line(int x1, int y1, int x2, int y2, unsigned char coul)
{
   int x_chan, y_chan;                // Pour le changement dans x et y
   int offset = (y1<<8)+(y1<<6) + x1; // Calcule l'offset dans la RAM
   int ydiff = y2-y1;                 // Calcule la difference entre y2 et y1
   int deviation =  0;                // Initialise la deviation a 0;

   if (ydiff < 0)                     // Si la ligne va dans un direction -
   {
     ydiff = -ydiff;
     y_chan = -320;
   }
   else y_chan = 320;

   int xdiff = x2-x1;                 // Calcule la difference entre x2 et x1

   if (xdiff < 0)                     // Si la ligne va dans un direction +
   {
	 xdiff = -xdiff;
	 x_chan = -1;
   }

   else x_chan = 1;

   if (xdiff > ydiff)                 // si la difference est + grande
   {                                  // sur l'axe X
     int longueur = xdiff+1;
	for(int i = 0; i < longueur; i++)
     {
	  virtuel[offset] = coul;
       offset+=x_chan;
       deviation+=ydiff;
     if (deviation>xdiff)             // Est-ce le temps de changer Y?
     {
	 deviation-=xdiff;
	 offset+=y_chan;
     }
    }
   }
   else                                // Difference + grande sur Y
   {
	int longueur = ydiff+1;
     for(int i = 0; i < longueur; i++)
     {
	  virtuel[offset] = coul;
	  offset+=y_chan;
	  deviation+=xdiff;
	if (deviation>0)                  // Est-ce le temps de changer X?
	{
	  deviation-=ydiff;
	  offset+=x_chan;
	}
    }
  }
}

/////////////////////////////////////////////////////////////////////////
// precalc - Calcule le tableau de sinus/cosinus                       //
/////////////////////////////////////////////////////////////////////////
void precalc()
{
  for(int angle=0; angle<360; angle++)
  {
	 SinTable[angle]=sin(angle*M_PI/180.0);
	 CosTable[angle]=cos(angle*M_PI/180.0);
  }
}

/////////////////////////////////////////////////////////////////////////
// copie_matrice -  copie une matrice source vers matrice destination  //
/////////////////////////////////////////////////////////////////////////
void copie_matrice(_mat4x4 source, _mat4x4 dest)
{
  memcpy(dest,source,sizeof(_mat4x4));
}


/////////////////////////////////////////////////////////////////////////
// mult_matrice - multiplie 2 matrices et mets le resultat dans dest   //            //
/////////////////////////////////////////////////////////////////////////
void mult_matrice(_mat m1, _mat m2, _mat dest)
{
  for(short i=0;i<4;i++)
    for(short j=0;j<4;j++)
	 dest[i][j]=
	 m1[i][0]*m2[0][j]+
	 m1[i][1]*m2[1][j]+
	 m1[i][2]*m2[2][j]+
	 m1[i][3]*m2[3][j];
}


/////////////////////////////////////////////////////////////////////////
// ident_matrice - construit une matrice identite                      //
/////////////////////////////////////////////////////////////////////////
void ident_matrice(_mat m)
{
    memset(m,NULL,sizeof(_mat));
    m[0][0] = 1.0;
    m[1][1] = 1.0;
    m[2][2] = 1.0;
    m[3][3] = 1.0;
}

/////////////////////////////////////////////////////////////////////////
// echelle - matrice de changement d'echelle                           //
/////////////////////////////////////////////////////////////////////////
void echelle(_mat m,float ex,float ey, float ez)
{
   _mat emat;

   ident_matrice(emat);
   emat[0][0]=ex;
   emat[1][1]=ey;
   emat[2][2]=ez;

   mult_matrice(m,emat,mat1);
   copie_matrice(mat1,m);
}

/////////////////////////////////////////////////////////////////////////
// translation - matrice de translation                                //
/////////////////////////////////////////////////////////////////////////
void translation(_mat m,float tx,float ty,float tz)
{
   _mat tmat;

   ident_matrice(tmat);
   tmat[3][0]=tx;
   tmat[3][1]=ty;
   tmat[3][2]=tz;

   mult_matrice(m,tmat,mat1);
   copie_matrice(mat1,m);
}


/////////////////////////////////////////////////////////////////////////
// rotation - matrice de rotation                                      //
/////////////////////////////////////////////////////////////////////////
void rotation(_mat m,int ax,int ay,int az)
{
  _mat xmat, ymat, zmat;

  ident_matrice(xmat);
  ident_matrice(ymat);
  ident_matrice(zmat);

  xmat[1][1] =  COS(ax);  xmat[1][2] = SIN(ax);
  xmat[2][1] = -SIN(ax);  xmat[2][2] = COS(ax);

  ymat[0][0] =  COS(ay);  ymat[0][2] = -SIN(ay);
  ymat[2][0] =  SIN(ay);  ymat[2][2] =  COS(ay);

  zmat[0][0] =  COS(az);  zmat[0][1] =  SIN(az);
  zmat[1][0] = -SIN(az);  zmat[1][1] =  COS(az);

  mult_matrice(m,ymat,mat1);
  mult_matrice(mat1,xmat,mat2);
  mult_matrice(mat2,zmat,m);
}

/////////////////////////////////////////////////////////////////////////
// projection - transformation 3D -> 2D                                //
/////////////////////////////////////////////////////////////////////////
void projection(_sommet *sommet)
{
   if(!sommet->monde.z) sommet->monde.z=1;
   sommet->ecran.x = MX + sommet->monde.x * (DISTANCE / sommet->monde.z);
   sommet->ecran.y = MY + sommet->monde.y * (DISTANCE / sommet->monde.z);
}

/////////////////////////////////////////////////////////////////////////
// transformation - multiplication de chaque sommet par la matrice     //
/////////////////////////////////////////////////////////////////////////
void transformation(_objet *object, _mat m)
{
   int v;
   _sommet *sommet;

   for(v=0; v<object->nbsommet; v++)
   {
	 sommet = &object->sommet[v];

	 sommet->monde.x = sommet->local.x*m[0][0]+
				    sommet->local.y*m[1][0]+
				    sommet->local.z*m[2][0]+
								m[3][0];

	 sommet->monde.y = sommet->local.x*m[0][1]+
				    sommet->local.y*m[1][1]+
				    sommet->local.z*m[2][1]+
								m[3][1];

	 sommet->monde.z = sommet->local.x*m[0][2]+
				    sommet->local.y*m[1][2]+
				    sommet->local.z*m[2][2]+
								m[3][2];
	 projection(sommet);
   }
}

/////////////////////////////////////////////////////////////////////////
// Initialisation des sommets de l'objet                               //
/////////////////////////////////////////////////////////////////////////
void initialise_objet(_objet *objet)
{
  objet->nbsommet=8;
  objet->nbligne=12;
  for (int i=0;i<objet->nbsommet;i++)
  {
    objet->sommet[i].local.x=Cube[i].x;
    objet->sommet[i].local.y=Cube[i].y;
    objet->sommet[i].local.z=Cube[i].z;
  }
  for (i=0;i<objet->nbligne;i++)
  {
    objet->ligne[i].x = Ligne[i].x;
    objet->ligne[i].y = Ligne[i].y;
  }
}

/////////////////////////////////////////////////////////////////////////
// dessine_objet - dessine les sommets de l'objet                      //
/////////////////////////////////////////////////////////////////////////
void dessine_objet(_objet *objet)
{
  _2D deb, fin;

  for (int l=0;l<objet->nbligne;l++)
  {
    deb.x = objet->sommet[objet->ligne[l].x].ecran.x;
    deb.y = objet->sommet[objet->ligne[l].x].ecran.y;

    fin.x = objet->sommet[objet->ligne[l].y].ecran.x;
    fin.y = objet->sommet[objet->ligne[l].y].ecran.y;

    line(deb.x,deb.y,fin.x,fin.y,31);
  }
}

//------------------------ FONCTION PRINCIPALE --------------------------//


void main(void)
{
  int angle=0;
  _objet cube;

  asm {MOV AX,0x13; INT 0x10}
  precalc();
  initialise_objet(&cube);

  while(!kbhit())
  {
    memset(virtuel,0,64000L);

    ident_matrice(matrice);
    echelle(matrice,20,20,20);
    rotation(matrice,angle,angle,angle);
    translation(matrice,0,0,-100);

    transformation(&cube,matrice);
    dessine_objet(&cube);

    while(!(inp(0x3DA)&8));
    memcpy(ecran,virtuel,64000L);
    if (angle++ == 359) angle = 0;
  };

  delete []virtuel;
  asm {MOV AX,0x03; INT 0x10}
}
