//----------------------------------------------------------------------//
// FICHIER              : TUNNEL.CPP                                    //
// AUTEUR               : Shaun Dore                                    //
// DESCRIPTION          : Tunnel avec texture                           //
// DATE DE MODIFICATION : 07-06-99                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

#define DISTANCE 6000          // Perspective
#define EPSILON .0000000000001 // Evite floating point error (compilateur 16-bit)

#include <mem.h>               // memset, memcpy
#include <math.h>              // cos, sin, M_PI
#include <stdio.h>             // fread, printf
#include <conio.h>             // getch, kbhit
#include <alloc.h>             // farmalloc

// Pointeur sur adresse de la memoire video (A000:0000h)
char *ecran = (char *) (0xA0000000L);

// Pointeur sur memoire tampon video
char *virtuel = new unsigned char[64000L];

// Pointeur sur texture map (256x256)
char *texture = (unsigned char*) farmalloc(65536L);

// Tableau pre-calculer des rayons
char *tab_rayon = new unsigned char[64000L];

// Tableau pre-calculer des angles
char *tab_angle = new unsigned char[64000L];


// Fixe la palette VGA correspondant a l'image chargee en memoire
void setpal(unsigned char col,unsigned char r,unsigned char g,unsigned char b)
{
	outp (0x03C8,col);
	outp (0x03C9,r);
	outp (0x03C9,g);
	outp (0x03C9,b);
}

// Decode un fichier PCX encoder Run Length Encoding
int loadpcx(char *nomfich, unsigned long taille)
{
  unsigned char data, nb_octets, palette[768];
  unsigned long index = 0;
  unsigned int  index_rle;
  FILE *pcxfile;
  if (!(pcxfile = fopen(nomfich, "rb"))) return 0;
  fseek(pcxfile, -768, SEEK_END);
  fread(&palette, 768, 1, pcxfile);
  for (int col=0;col<=255;col++)
    setpal(col,palette[col*3]>>2,palette[col*3+1]>>2,palette[col*3+2]>>2);
  fseek(pcxfile, 128, SEEK_SET);
  do
  {
    fread(&data, 1, 1, pcxfile);
	 if ((data & 0xC0) == 0xC0)     // Verifie si l'octet est compresse, avec les
	 {                              // 2 premier bit (11000000). Si oui, les
		nb_octets = (data & 0x3F);   // 6 derniers bit devienne une boucle contenant
		fread(&data, 1, 1, pcxfile); // le nombre de fois qu'il faut repeter
		for (index_rle=1; index_rle<=nb_octets; index_rle++)  // l'octet
		texture[index++] = data;
	 }
	 else texture[index++] = data;   // Sinon il n'est pas compresse...
  } while(index < taille);         // Tant qu'on a pas terminer de decoder
  fclose(pcxfile);
  return 1;
}


// Calcule le rayon et l'angle pour chaque pixels sur l'ecran
void calc_tables()
{
  unsigned int offset=0;

  for (int y=-80; y<80; y++)
	 for (int x=-160; x<160; x++)
	 {
		offset= (x+160)+((y+80) * 320);
		tab_rayon[offset] = (EPSILON+sqrt( x*x + y*y ));
		if (x!=0 && y != 0)
		 tab_angle[offset] = (atan2(y,x) * 256 / M_PI / 2);
		else
		 tab_angle[offset] = (atan2(y+EPSILON,x+EPSILON) * 256 / M_PI / 2);
	 }
  /*
	  On calcule la distance du pixel de l'origine (160,100) par Pythagore
	  sqrt(x^2+y^2), on obtient la table des rayons possibles. Atan2(x,y)
	  retourne l'angle du pixel par rapport a l'origine et on converti de
	  radians vers degree par 360/pi/2 (256 dans notre cas)
  */
}

// Dessine l'effet
void dessine_tunnel(unsigned char r, unsigned char a)
{
	unsigned int yoff;
	unsigned char rayon, angle;

	for (int y=0;y<160;y++)
	{
	 yoff = (y<<8)+(y<<6);
	 for (int x=0;x<320;x++)
	 {
	  rayon = r+tab_rayon[yoff+x];
	  angle = a+tab_angle[yoff+x];
	  virtuel[yoff+6400+x] = texture[(rayon<<8) + angle];
	 }
	}
	/*
		Dessine la texture sur l'ecran, en utilisant le rayon et l'angle
		pour determiner le textel. r et a servent a deplacer la texture.
	*/
}


void main()
{
  unsigned char angle=0, rayon=0;
  float CosTable[256];
  char fichier[] = "texture.pcx";
  for(int i=0; i<256; i++) CosTable[i]=cos(i*M_PI/128);   // Table precalculer

  printf("Calcul des tables . . .\n");
  calc_tables();
  memset(virtuel,0,64000L);
  asm {mov ax,0x13;int 0x10}                              // Mode 13h
  if(!loadpcx(fichier, 65536L))                           // Charger texture
  {
	 asm {mov ax,0x03;int 0x10}                            // Erreur!
	 printf("ERREUR: Incapable de charger %s !\n", fichier);
  }
  else
  {
	 while(!(kbhit()))
	 {
		dessine_tunnel(angle++,rayon++);
		memcpy(ecran,virtuel,64000L);  // Copie le contenu du buffer
	 }
	 getch();
	 for (int y=-80; y<80; y++)
		for (int x=-160; x<160; x++)
		{
			tab_rayon[(x+160)+((y+80) * 320)] = DISTANCE/(EPSILON+sqrt( x*x + y*y ));
		}
	 while(!(kbhit()))
	 {
		dessine_tunnel(angle--,rayon++);
		memcpy(ecran,virtuel,64000L);  // Copie le contenu du buffer
	 }
	 asm {mov ax,0x03;int 0x10}
  }
  delete []virtuel;                  // Libere la memoire pour le buffer
  delete []tab_angle;
  delete []tab_rayon;
  farfree(texture);                  // ainsi que pour l'image
}
