//----------------------------------------------------------------------//
// FICHIER              : 2DCHAP1.CPP			                        //
// AUTEUR               : Shaun Dore					                //
// DESCRIPTION  	    : Starfield horizontal pour demontrer putpixel  //
// DATE DE MODIFICATION : 30-09-97	                              	    //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire COMPACT          //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include                                                     //
//----------------------------------------------------------------------//

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

//----------------------------------------------------------------------//
// Declaration des constantes                                           //
//----------------------------------------------------------------------//

#define MAX_ETOILES 500

//----------------------------------------------------------------------//
// Types personalises                                                   //
//----------------------------------------------------------------------//

typedef struct type_etoile  // Pour contenir les infos sur chaque etoiles
{                           // Coordonnees x,y et "z"
  int x,y,z;
};

//----------------------------------------------------------------------//
// Variables globales           				  				        //
//----------------------------------------------------------------------//

char *ecran = (char *) (0xA0000000L);  // Pointeur sur RAM video

//----------------------------------------------------------------------//
// setmode - Appelle le mode passer en parametre                        //
//----------------------------------------------------------------------//
void setmode(unsigned int mode)
{
  asm {
	   MOV AX, mode
	   INT 0x10
	 }
}

//----------------------------------------------------------------------//
// putpixel - Affiche un pixel directement dans la memoire              //
//----------------------------------------------------------------------//
void putpixel (int x, int y, unsigned char coul)
{
  ecran[(y*320)+x] = coul;
}

//----------------------------------------------------------------------//
// Fonction MAIN		           				  			            //
//----------------------------------------------------------------------//
void main()
{
  // Rappel mathematique: % = modulo, le reste de la division entiere
  // x mod y donne toujours entre 0 et y ex: x % 15 donne toujours
  // un nombre entre 0 et 15. Bon moyen pour ramener des valeurs dans
  // un cadre defini. On s'en sert en adressage disperse.
  int et;
  unsigned char coul;
  type_etoile etoiles[MAX_ETOILES]; // Tableau d'etoiles du type etoiles
				    // definie plus haut
  setmode(0x13);
  randomize();                      // Generateur de nombres aleatoires
  for (int i=0;i<=MAX_ETOILES;i++)  // Initialise la structure a 0
  {
    etoiles[i].x = 0;
    etoiles[i].y = 0;
    etoiles[i].z = 0;
  }
  do
  {
    for (et=0;et<MAX_ETOILES;et++)
    {
	 for (unsigned int ralenti=0; ralenti<=1000; ralenti++) {} // Ralentir!
	 putpixel(etoiles[et].x,etoiles[et].y,0);
	 //efface ancienne position
	 etoiles[et].x = etoiles[et].x - (etoiles[et].z % 15 + 1);
	 // la vitesse de deplacement en fonction du z
	 if (etoiles[et].x <= 0)         // si l'etoile est a gauche...
	 {
	   etoiles[et].x = 319;          // on la remet a droite,
	   etoiles[et].y = random (200); // a une nouvelle hauteur,
	   etoiles[et].z = random (256); // sur un nouveau z.
      }
      coul = etoiles[et].z % 15 + 17;             // 17-32 = tons de gris
      putpixel(etoiles[et].x,etoiles[et].y,coul); // affiche nouvelle position
    }
  } while (!kbhit());

  setmode(0x03);
  printf("Shaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun/");
}
