//----------------------------------------------------------------------//
// FICHIER              : FXBUMP.CPP                                    //
// AUTEUR               : Shaun Dore                                    //
// DESCRIPTION          : Bump mapping 2D                               //
// DATE DE MODIFICATION : 08-05-98                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

#include <mem.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>

#define  AMBIENT  0
#define  SPECULAR 110
#define  DIFFUSE  175

char *ecran   = (char *) (0xA0000000L);     // Ecran physique
char *virtuel = new unsigned char[64000L];  // Ecran virtuel
char *bumpmap = new unsigned char[64000L];  // Image representant bumpmap
char *envmap  = (char *)farmalloc(65536L);  // > que 65535 donc farmalloc

//----------------------------------------------------------------------//
// setpal - fixe les attributs r,g,b                                    //
//----------------------------------------------------------------------//
void setpal(unsigned char col, unsigned char r, unsigned char g, unsigned char b)
{
  outp (0x03C8,col);
  outp (0x03C9,r);
  outp (0x03C9,g);
  outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// loadpcx - Charge en memoire un fichier .PCX                          //
//----------------------------------------------------------------------//
int loadpcx(char *nomfich,unsigned long taille,char *image)
{
  unsigned char data, nb_octets;
  unsigned long index = 0;
  unsigned int  indexrle;
  FILE *fichpcx;

  if (!(fichpcx = fopen(nomfich, "rb"))) return 0;
  fseek(fichpcx, 128, SEEK_SET);

  do
  {
    fread(&data, 1, 1, fichpcx);
    if ((data & 0xC0) == 0xC0)
    {
      nb_octets = (data & 0x3F);
      fread(&data,1,1,fichpcx);
      for (indexrle=1;indexrle<=nb_octets;indexrle++) image[index++]=data;
    }
    else image[index++] = data;
  } while(index < taille);

  fclose(fichpcx);
  return 1;
}

//----------------------------------------------------------------------//
// preparepal - ajuste la palette (bleu)                                //
//----------------------------------------------------------------------//
void preparepal()
{
  for (int i=0; i<192;i++) setpal(i,0,0,(i*63/192));
  for (i=192;i<256;i++)    setpal(i,i-192,i-192,63);
}

//----------------------------------------------------------------------//
// min - retourne le nombre le plus petit                               //
//----------------------------------------------------------------------//
int min(int nb1, int nb2)
{
   return ( (nb1 < nb2) ? nb1 : nb2);
}

//----------------------------------------------------------------------//
// calcenvmap - Precalculer les couleurs possibles selon les normales   //
//----------------------------------------------------------------------//
void calcenvmap()
{
  float nX,nY,nZ;
  for (int y=0;y<256;y++)
   for (int x=0;x<256;x++)
   {
     nX=(x-128)/128.0;
     nY=(y-128)/128.0;
     nZ=1-sqrt(nX*nX+nY*nY);
     if (nZ<0) nZ=0;

     // Phong = ambient + dif*dot + dot^2 * spec
     envmap[x+y*256] = AMBIENT+(unsigned char)min(255,(nZ*DIFFUSE+nZ*nZ*SPECULAR));

     // Lambert = ambient + diffuse * angle
     // envmap[x+y*256] = AMBIENT + DIFFUSE * nZ;
   }
}

//----------------------------------------------------------------------//
// bump - calcule les normales de surfaces pour chaque pixel            //
//----------------------------------------------------------------------//
void bump(int lx,int ly)
{
   int nx,ny;

   // Source lumineuse a l'origine
   lx+=128;
   ly+=128;

   int offset=0;
   for (int y=0;y<200;y++)
   {
      for (int x=0;x<320;x++)
      {
	 // Calcul les pentes (pseudo-normales)
	 nx=bumpmap[offset+1]-bumpmap[offset-1];
	 ny=bumpmap[offset+320]-bumpmap[offset-320];

	 // Ajuste les pseudo-normales selon la source lumineuse
	 nx-=(x-lx);
	 ny-=(y-ly);

	 // On s'assure d'etre dans les limites
	 if (nx>255 || nx<0) nx=255;
	 if (ny>255 || ny<0) ny=255;

	 // On affiche dans le buffer le pixel correspondant
	 virtuel[offset++]=envmap[nx+ny*256];
      }
   }
}

//----------------------------------------------------------------------//
// bumpmap - deplace la source lumineuse sur la surface                 //
//----------------------------------------------------------------------//
void bumpmapping()
{
   float lx,ly,loop;

   while(!kbhit())
   {
     // Simplement pour faire bouger la source lumineuse
     loop++;
     lx = cos(loop/10)*100+160;
     ly = sin(loop/13)*70+100;

     bump(lx,ly);
     while (!(inp(0x3DA) & 8));
	memcpy(ecran,virtuel,64000L);
   };
}

//---------------------- FONCTION PRINCIPALE --------------------------//


void main()
{
 char *fich = "bumpmap.pcx";

 asm {MOV AX, 0x13; INT 0x10}

 if (loadpcx(fich,64000L,bumpmap))
 {
   calcenvmap();
   preparepal();
   bumpmapping();
 }
 else
 {
   asm {MOV AX, 0x03; INT 0x10}
   printf("ERREUR: Incapable de charger %s !",fich);
   return;
 }

 delete[] virtuel;
 delete[] bumpmap;
 farfree(envmap);
 asm {MOV AX, 0x03; INT 0x10}
}

