//----------------------------------------------------------------------//
// FICHIER              : 2DCHAP4.CPP                                   //
// AUTEUR               : Shaun Dore                                    //
// DESCRIPTION          : Animations et ecrans virtuels                 //
// DATE DE MODIFICATION : 28-01-98	                                    //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include                                                     //
//----------------------------------------------------------------------//

#include <mem.h>
#include <stdio.h>
#include <conio.h>

//----------------------------------------------------------------------//
// Constantes                                                           //
//----------------------------------------------------------------------//

#define MIN_Y 20
#define MAX_Y 160

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran  = (char *) (0xA0000000L);      // ptr sur RAM Video
char *virtuel = new unsigned char[64000L];  // ptr sur ecran virtuel


//----------------------------------------------------------------------//
// setmode - Appelle le mode passer en parametre                        //
//----------------------------------------------------------------------//
void setmode(unsigned int mode)
{
  asm {
	   MOV AX, [mode]
	   INT 0x10
	 }
}

//----------------------------------------------------------------------//
// clsvirt - vide l'ecran                                               //
//----------------------------------------------------------------------//
void clsvirt()
{
  memset(virtuel,0,64000L);
}

//----------------------------------------------------------------------//
// cpyvirt - copie un ecran vers un autre                               //
//----------------------------------------------------------------------//
void cpyvirt()
{
  memcpy(ecran,virtuel,64000L);
}

//----------------------------------------------------------------------//
// putpixel - Affiche un pixel                                          //
//----------------------------------------------------------------------//
void putpixel(int x, int y, unsigned char col)
{
  virtuel[(y*320)+x] = col;
}

//----------------------------------------------------------------------//
// hline - Dessine une ligne horizontale                                //
//----------------------------------------------------------------------//
void hline(int x1, int x2, int y, unsigned char coul)
{
  memset(virtuel+x1+(y*320),coul,(x2-x1));
}

//----------------------------------------------------------------------//
// setpal - fixe les attributs r,g,b                                    //
//----------------------------------------------------------------------//
void setpal(unsigned char col,unsigned char r, unsigned char g, unsigned char b)
{
  outp (0x03C8,col); // Envoie les informations au DAC
  outp (0x03C9,r);
  outp (0x03C9,g);
  outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// preparepal - modifie la palette a mon gout                           //
//----------------------------------------------------------------------//
void preparepal()
{
  for (int i=0;i<256;i++) setpal(i,0,0,0);
  for (i=1;i<=10;i++)	  setpal(i,0,0,i*3);
  for (i=11;i<=20;i++)	  setpal(i,(i-10)*3,0,0);
  for (i=21;i<=30;i++)	  setpal(i,0,(i-20)*3,0);
}


//----------------------------------------------------------------------//
// Barre - Anime trois barres sur l'ecran                               //
//----------------------------------------------------------------------//
void barre(int &y, unsigned char coul, int &sens)
{
  int ligne,i,x;

  for(ligne=0;ligne<=10;ligne++)
  {
    hline(0,319,y+ligne,coul);
    if(ligne < 5) coul++;
    if(ligne > 5) coul--;
    if(y>=MAX_Y)  sens=-1;
    if(y<=MIN_Y)  sens=1;
  }
  y+=sens;
}


//----------------------------------------------------------------------//
// Fonction MAIN                                                        //
//----------------------------------------------------------------------//

void main()
{
  int sensg =  1;
  int sensb =  1;
  int sensr = -1;
  int yb = MIN_Y;
  int yr = MIN_Y + 25;
  int yg = MIN_Y + 25;

  setmode(0x13);
  preparepal();
  do
  {
    clsvirt();
    barre(yr,15,sensr);
    barre(yb,5, sensb);
    barre(yg,25,sensg);
    cpyvirt();
  } while (!kbhit());

  delete []virtuel;       // Ne pas oublier de liberer la memoire!
  setmode(0x03);
  printf("Shaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun");
}
