//----------------------------------------------------------------------//
// FICHIER              : 2DCHAP6.CPP                                   //
// AUTEUR               : Shaun Dore                                    //
// DESCRIPTION          : Les sprites                                   //
// DATE DE MODIFICATION : 21-04-98                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include                                                     //
//----------------------------------------------------------------------//

#include <mem.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>

//----------------------------------------------------------------------//
// Constantes                                                           //
//----------------------------------------------------------------------//

const unsigned int  largeur = 16; // largeur du bitmap contenant le sprite
const unsigned int  hauteur = 16; // hauteur du bitmap contenant le sprite
const unsigned long taille  = hauteur*largeur;  // taille du bitmap

//----------------------------------------------------------------------//
// Structure de donnees                                                 //
//----------------------------------------------------------------------//

typedef struct tsprite
{
  char *graphics;          // pointeur sur donnes graphiques
  int x, y;                // largeur et hauteur du sprite
  int px,py;               // position courante du sprite (optionel)
  int sx,sy;               // vitesse courante su sprite  (optionel)
};

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran   = (char *) (0xA0000000);     // ptr sur memoire video
char *virtuel = new char[64000L];          // ptr sur ecran virtuel
char *bitmap  = new char[taille];

//----------------------------------------------------------------------//
// setmode - Appelle le mode passer en parametre                        //
//----------------------------------------------------------------------//
void setmode(unsigned int mode)
{
  asm {
	   MOV AX, [mode]
	   INT 0x10
	 }
}

//----------------------------------------------------------------------//
// setpal - Modifie la palette                                          //
//----------------------------------------------------------------------//
void setpal(unsigned char coul,unsigned char r,unsigned char g,unsigned char b)
{
   outp (0x03C8,coul);
   outp (0x03C9,r);
   outp (0x03C9,g);
   outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// loadpcx - Charge en memoire un fichier .PCX                          //
//----------------------------------------------------------------------//
int loadpcx(char *nomfich,unsigned long taille,char *image)
{
  unsigned char data, nb_octets, palette[768];
  unsigned long index = 0;
  unsigned int  indexrle;
  FILE *fichpcx;

  if (!(fichpcx = fopen(nomfich, "rb"))) return 0;
  fseek(fichpcx, -768, SEEK_END);
  fread(&palette, 768, 1, fichpcx);
  for (int coul=0;coul<=255;coul++)
    setpal(coul,palette[coul*3]>>2,palette[coul*3+1]>>2,palette[coul*3+2]>>2);
  fseek(fichpcx, 128, SEEK_SET);
  do
  {
    fread(&data, 1, 1, fichpcx);
    if ((data & 0xC0) == 0xC0)
    {
	 nb_octets = (data & 0x3F);
	 fread(&data,1,1,fichpcx);
	 for (indexrle=0;indexrle<nb_octets;indexrle++) image[index++]=data;
    }
    else image[index++] = data;
  } while(index < taille);

  fclose(fichpcx);
  return 1;
}

//----------------------------------------------------------------------//
// getsprite - Mets en memoire un sprite                                //
//----------------------------------------------------------------------//
void liresprite(int x1,int y1,int larg,int haut, tsprite *sprite)
{
  sprite->x = larg;
  sprite->y = haut;
  sprite->graphics = new char[larg*haut];

  for (int y=0; y<haut; y++)
    for (int x=0; x<larg; x++)
	 sprite->graphics[(y*larg)+ x] = bitmap[(y1+y)*largeur+x+x1];
}


//----------------------------------------------------------------------//
// putsprite - Affiche un sprite version ordinaire                      //
//----------------------------------------------------------------------//
void putsprite(int x1,int y1,tsprite *sprite)
{
  for (int y=0; y<sprite->y; y++)
   for (int x=0; x<sprite->x; x++)
	virtuel[(y1+y)*320+x+x1] = sprite->graphics[y*sprite->x+x];
}

//----------------------------------------------------------------------//
// putspriteT - Affiche un sprite version transparente                  //
//----------------------------------------------------------------------//
void putspriteT(int x1,int y1,tsprite *sprite)
{
  unsigned char octet;
  for (int y=0; y<sprite->y; y++)
   for (int x=0; x<sprite->x; x++)
   {
	octet = sprite->graphics[y*sprite->x+x];
	if (octet) virtuel[(y1+y)*320+x+x1] = octet;
   }
}

//----------------------------------------------------------------------//
// putspriteE - Affiche un bitmap version changement d'echelle          //
//----------------------------------------------------------------------//
void putspriteE(int x1, int y1, float echelle, tsprite *sprite)
{
  float tx,ty;
  float sy = sprite->y / echelle;
  float sx = sprite->x / echelle;

  float centreX = x1 - sx/2;
  float centreY = y1 - sy/2;

  for (int y=0;y<sy;y++)
  {
    ty = (y * echelle);
    for (int x=0;x<sx;x++)
    {
      tx = (x * echelle);
	 virtuel[(centreY+y)*320+x+centreX]=sprite->graphics[(tx)+((int)(ty)*sprite->x)];
    }
  }
}

//----------------------------------------------------------------------//
// putspriteR - Affiche un bitmap version rotation 2D                   //
//----------------------------------------------------------------------//
void putspriteR(int x1, int y1, float angle, tsprite *sprite)
{
  float tx,ty;
  float centreX,centreY;

  for (int y=0;y<sprite->y;y++)
  {
   centreY = y-8;
   for (int x=0;x<sprite->x;x++)
   {
	centreX = x-8;
	tx = centreX * cos(angle) - centreY * sin(angle) + 8;
	ty = centreX * sin(angle) + centreY * cos(angle) + 8;
	if ( (tx>0) && (ty>0) && (tx<sprite->x) && (ty<sprite->y))
	 virtuel[(y1+y)*320+x+x1] = sprite->graphics[(tx+(int)(ty)*sprite->x)];
   }
  }
}

//----------------------------------------------------------------------//
// Fonction MAIN()                                                      //
//----------------------------------------------------------------------//
void main()
{
  tsprite vaisseau;

  setmode(0x13);
  memset(virtuel,2,64000L);
  if(!(loadpcx("vaisseau.pcx",taille,bitmap)))     // Charger le bitmap
  {
    setmode(0x03);
    printf("ERREUR: Incapable de charger vaisseau.pcx!\n");
    return;
  }
  liresprite(0,0,16,16,&vaisseau);                  // Initialiser le sprite

  // Affichage ordinaire
  putsprite(160-(vaisseau.x/2),100-(vaisseau.x/2),&vaisseau);
  memcpy(ecran,virtuel,64000L);                     // Afficher le sprite
  gotoxy(1,1);printf("Sprite version ordinaire");
  getch();

  // Affichage transparent
  memset(virtuel,2,64000L);
  putspriteT(160-(vaisseau.x/2),100-(vaisseau.x/2),&vaisseau);
  memcpy(ecran,virtuel,64000L);                     // Afficher le sprite
  gotoxy(1,1);printf("Sprite version transparent");
  getch();


  // Affichage avec changement d'echelle
  memset(virtuel,0,64000L);
  putspriteE(160,100,.1,&vaisseau);                  // Changement d'echelle
  memcpy(ecran,virtuel,64000L);
  gotoxy(1,1);printf("Sprite version changment d'echelle");
  getch();

  // Table precalculer pour les rotations 2D
  memset(ecran,0,64000L);
  float CosTable[256];
  unsigned char angle=0;
  for(int i=0; i<256; i++) CosTable[i]=cos(i*M_PI/128);

  // Rotation du sprite
  while(!(kbhit()))
  {
    memset(virtuel,0,64000L);
    putspriteR(160,100,CosTable[angle]*2*M_PI,&vaisseau);
    while(!(inp(0x3da)&8));
    memcpy(ecran+(8*320),virtuel,64000L-(8*320));
    gotoxy(1,1);printf("Sprite version rotation");
    angle++;
  }

  setmode(0x03);
  printf("Dump de sprite:\n\n");
  for (int y=0;y<16;y++)
  {
   printf("\n");
   for (int x=0;x<16;x++)
    printf("%c ",bitmap[(y*16)+x]);
  }
  printf("\n\nShaun Dore\ndores@videotron.ca\nhttp://pages.infinit.net/shaun/");

  delete[] bitmap;
  delete[] virtuel;
  delete[] vaisseau.graphics;
}
