//----------------------------------------------------------------------//
// FICHIER              : FXBUMP.CPP                                    //
// AUTEUR               : Shaun Dore                                    //
// DESCRIPTION          : Rotozoom                                      //
// DATE DE MODIFICATION : 12-01-99                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

#include <mem.h>               // memset, memcpy
#include <math.h>              // cos, sin, M_PI
#include <stdio.h>             // fread, printf
#include <conio.h>             // getch, kbhit
#include <alloc.h>             // farmalloc

// Pointeur sur adresse de la memoire video (A000,0000)
char *ecran = (char *) (0xA0000000L);

// Pointeur sur memoire tampon video
char *virtuel = new unsigned char[64000L];

// Pointeur sur image bitmap
// J'ai du utiliser ici farmalloc car l'operateur new ne semble pas etre
// capable de reserver un bloc de plus de 64k(65535), donc farmalloc nous
// permet d'allouer de la memoire dans le tas externe au segment de donnees
// (far heap).
char *bitmap = (unsigned char*) farmalloc(65536L);

// Fixe la palette VGA correspondant a l'image chargee en memoire
void setpal(unsigned char col,unsigned char r,unsigned char g,unsigned char b)
{
   outp (0x03C8,col);
   outp (0x03C9,r);
   outp (0x03C9,g);
   outp (0x03C9,b);
}

// Decode un fichier PCX encoder Run Length Encoding
int loadpcx(char *nomfich, unsigned long taille)
{
  unsigned char data, nb_octets, palette[768];
  unsigned long index = 0;
  unsigned int  index_rle;
  FILE *pcxfile;
  if (!(pcxfile = fopen(nomfich, "rb"))) return 0;
  fseek(pcxfile, -768, SEEK_END);
  fread(&palette, 768, 1, pcxfile);
  for (int col=0;col<=255;col++)
    setpal(col,palette[col*3]>>2,palette[col*3+1]>>2,palette[col*3+2]>>2);
  fseek(pcxfile, 128, SEEK_SET);
  do
  {
    fread(&data, 1, 1, pcxfile);
    if ((data & 0xC0) == 0xC0)     // Verifie si l'octet est compresse, avec les
    {                              // 2 premier bit (11000000). Si oui, les
      nb_octets = (data & 0x3F);   // 6 derniers bit devienne une boucle contenant
      fread(&data, 1, 1, pcxfile); // le nombre de fois qu'il faut repeter
      for (index_rle=1; index_rle<=nb_octets; index_rle++)  // l'octet
	bitmap[index++] = data;
    }
    else bitmap[index++] = data;   // Sinon il n'est pas compresse...
  } while(index < taille);         // Tant qu'on a pas terminer de decoder
  fclose(pcxfile);
  return 1;
}

// Calcul le vecteur de rotation pour chaque pixel sur l'ecran
void rotozoom(float echelle, float angle)
{
  float bx, by;                        // bitmap x,y pos
  float cossc = cos(angle) * echelle;  // calcule d'avance le vecteur de
  float sinsc = sin(angle) * echelle;  // rotation et multiplie par l'echelle
  float ysin, ycos;                    // pour optimiser la vitesse
  unsigned int offset = 0;             // offset dans le buffer

  for (int y=0;y<200;y++)
  {
    ysin = y * sinsc;                  // Eviter de recalculer y
    ycos = y * cossc;
    for (int x=0;x<320;x++)
      {
	bx = x * cossc - ysin;         // Formule de rotation 2D
	by = x * sinsc + ycos;
	virtuel[offset++] = bitmap[bx + ((int)by<<8)];   // Affiche le pixel
      }                                                  // correspondant dans
  }                                                      // le double buffer
}

void main()
{
  unsigned char angle=0;
  float CosTable[256];
  char fichier[] = "fxroto.pcx";
  for(int i=0; i<256; i++) CosTable[i]=cos(i*M_PI/128);   // Table precalculer

  asm {mov ax,0x13;int 0x10}                              // Mode 13h
  if(!loadpcx(fichier, 65536L))                            // Charger l'image
  {
    asm {mov ax,0x03;int 0x10}                            // Erreur!
    printf("ERREUR: Incapable de charger %s !\n", fichier);
  }
  else
  {
    while(!(kbhit()))
    {
      rotozoom(CosTable[angle]*5,CosTable[angle]*2*M_PI);
      while (!(inp(0x3DA) & 8));
	 memcpy(ecran,virtuel,64000L);  // Copie le contenu du buffer
	 angle++;                      // Incremente l'angle de rotation
    }
    asm {mov ax,0x03;int 0x10}
  }
  delete []virtuel;                  // Libere la memoire pour le buffer
  farfree(bitmap);                  // ainsi que pour l'image
}
