//----------------------------------------------------------------------//
// FICHIER              : FXFEU.CPP                                     //
// AUTEUR       	    : Shaun Dore                                    //
// DESCRIPTION  	    : Effet de feu                                  //
// DATE DE MODIFICATION : 18-02-97                                      //
// COMPILATEUR          : Borland Turbo C++ Real Mode 16-bit compiler   //
// NOTES                : Compiler avec modele memoire Compact          //
//----------------------------------------------------------------------//

//----------------------------------------------------------------------//
// Fichiers include	                                                    //
//----------------------------------------------------------------------//

#include <conio.h>
#include <stdlib.h>

//----------------------------------------------------------------------//
// Variables globales                                                   //
//----------------------------------------------------------------------//

char *ecran = (char *) (0xA0000000L);
unsigned char flamme[320][80];

//----------------------------------------------------------------------//
// setpal - fixe les attributs r,g,b                                    //
//----------------------------------------------------------------------//
void setpal(unsigned char col, unsigned char r, unsigned char g, unsigned char b)
{
  outp (0x03C8,col);
  outp (0x03C9,r);
  outp (0x03C9,g);
  outp (0x03C9,b);
}

//----------------------------------------------------------------------//
// preparepal() - Initialise la palette a noir->rouge->jaune->blanc	  //			               			//
//----------------------------------------------------------------------//
void preparepal()
{
  for (int i=0; i<192;i++) setpal(i,(i*63/192),0,0);
  for (i=192;i<256;i++)    setpal(i,63,(i/2)-64,0);
}

//-----------------------------------------------------------------------//
// feu() - Pour determiner la couleur d'un pixel, on calcule sa valeur   //
// de couleur par la moyenne des 4 pixels en dessus de lui, c'est a      //
// dire ([x-1],[y] + [x][y+1] + [x+1][y+1] + [x][y+1]) et on divise par 4//
// Puis on trouve sa valeur de couleur col dans le tableau du feu flamme.//
//-----------------------------------------------------------------------//
void feu()
{
  unsigned char col;

  do
  {
   for (int x=5;x<315;x++)
    for (int y=125;y<199;y++)
    {
	// Moyenne des couleurs des pixels pour la couleur du nouveau
	col = ( flamme[x-1][y+1]+
		   flamme[x+1][y+1]+
		   flamme[x][y-1]+
		   flamme[x][y+1] ) / 4;
	// Initialise le foyer du feu et decremente la couleur
	if (y == 198) col = random(135) + 120;
	if (col != 0) col--;
	// Affiche le pixel selon la tableau flamme[x][y]
	ecran[(y<<8)+(y<<6)+x] = flamme[x][y] = col;
    }
  } while (!kbhit());
}

//----------------------------------------------------------------------//
// Fonction MAIN                                                        //
//----------------------------------------------------------------------//
void main()
{
  randomize();
  asm {MOV AX,0x13;INT 0x10}
  preparepal();
  feu();
  asm {MOV AX,0x03; INT 0x10}
}
