// Metaballs 2D
// DATE:	30/06/99
// AUTEUR:	Shaun Dor
// NOTE:	En 640x480, il est prfrable d'augmenter le rayon des metaballs


// MACROS ///////////////////////////////////////////////////////////////

// Rduit la taille des headers Windows
#define WIN32_LEAN_AND_MEAN  
// Macro qui retourne vrai si une touche est enfonce
#define Touche(VkCode) (GetAsyncKeyState(VkCode) & 0x8000 ? 1 : 0)

// INCLUDES /////////////////////////////////////////////////////////////

#include <windows.h>	// Include standard de tout programme Win32
#include <windowsx.h>	// Fonctionnalits supplmentaires de Win32
#include <ddraw.h>		// Header de DirectDraw
#include <math.h>       
#include "resource.h"

// Structure pour contenir les informations sur une metaball
typedef struct
{
  int X,        // Centre x
      Y,        // Centre y
      Rayon,    // Rayon de cette metaball
      Vx,       // Velocit x
      Vy;       // Velocit y

} META;
 
// GLOBALES /////////////////////////////////////////////////////////////

LPDIRECTDRAW		DirectDraw			= NULL;		// Objet DirectDraw
LPDIRECTDRAWSURFACE SurfacePrimaire		= NULL;		// Surface primaire
LPDIRECTDRAWSURFACE SurfaceSecondaire	= NULL;		// L'ecran virtuel de la surface primaire
LPDIRECTDRAWPALETTE DirectDrawPal		= NULL;		// Palette DirectDraw
PALETTEENTRY        Palette[256];					// Tableau des couleurs (CLUT)
DDSURFACEDESC		SurfaceDesc;					// Description de la surface
DDSCAPS				SurfaceCap;						// Capacits de la surface
HINSTANCE			InstancePrincipale	= NULL;		// Instance de l'application
HWND				HandlePrincipale	= NULL;		// Handle sur la fentre principale
UCHAR				*virtuel			= NULL;		// Ptr sur cran virtuel

BOOL Quitter = FALSE;	// Test pour savoir si on quitte l'app	
META *Metaball = NULL;	// Tableau dynamique pour les metaballs
UCHAR Texture[65536];	// Texture gnre pour dessiner les metaballs

// Variables usager

int ECRAN_X = 0;		// Rsolution horizontale
int ECRAN_Y = 0;		// Rsolution verticale
int NB_META = 0;		// Nombre de metaballs
int RAYON_META = 0;		// Rayon moyen des metaballs

// DCLARATIONS /////////////////////////////////////////////////////////

int  InitDirectDraw();		// Initialisation de DirectDraw
void CloseDirectDraw();		// Libre la mmoire des objets DirectDraw
void DessinePixel();		// Dessine des pixels sur l'cran secondaire
int  InitFenetre();			// Initialise la fentre

// FONCTIONS ////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// Gestionnaire d'vnements de la fentre
LRESULT CALLBACK WindowProc(HWND hWnd,     // Handle sur la fentre
                            UINT Msg,      // Identificateur du message
                            WPARAM wParam, // Paramtre supplmentaire
                            LPARAM lParam) // Paramtre supplmentaire
{
	// Analyse le message
	switch (Msg)
	{	
		// La fentre va tre dtruite
		case WM_DESTROY:
		{
			// Envoie un message  la fentre pour quitter
			PostQuitMessage(0);
			return 0;
		}	break;
		
		default:
			break;
	}
	// Le reste des messages au gestionnaire par dfaut
	return DefWindowProc(hWnd, Msg, wParam, lParam);
}

////////////////////////////////////////////////////////////////////////////
// Initialise et instancie une fentre
int InitFenetre()
{
	WNDCLASS ClasseFenetre;	
	HWND hWnd = NULL;		

	ClasseFenetre.style = CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	ClasseFenetre.lpfnWndProc = WindowProc;
	ClasseFenetre.cbClsExtra = 0;
	ClasseFenetre.cbWndExtra = 0;
	ClasseFenetre.hInstance = InstancePrincipale;
	ClasseFenetre.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	ClasseFenetre.hCursor = LoadCursor(NULL, IDC_ARROW);
	ClasseFenetre.hbrBackground = (struct HBRUSH__ *)GetStockObject(BLACK_BRUSH);
	ClasseFenetre.lpszMenuName = NULL;
	ClasseFenetre.lpszClassName = "Fenetre";
	
	// Enregistre la classe
	if (!RegisterClass(&ClasseFenetre))
	{
		MessageBox(NULL,
		           "Il y a eu une erreur dans l'enregistrement de la classe",
		           "Erreur",
		           MB_OK | MB_ICONERROR);
		return 0;
	};
	
	// Cration de la fentre
	hWnd = CreateWindow("Fenetre",              
	                    "Programmation Windows - Chapitre 2",          
	                    WS_POPUP | WS_VISIBLE, 
	                    CW_USEDEFAULT,         
	                    CW_USEDEFAULT,        
	                    CW_USEDEFAULT,         
	                    CW_USEDEFAULT,         
	                    NULL,                  
	                    NULL,                  
	                    InstancePrincipale,    
	                    NULL);   
	// Vrifie l'initialisation de la fentre
	if (!hWnd)
	{
		MessageBox(NULL,
		           "Il y a eu une erreur lors de la cration de la fentre",
		           "Erreur",
		           MB_OK | MB_ICONERROR);
		return 0;
	}
	// Sauvegarde l'handle de la fentre dans une globale
	HandlePrincipale = hWnd;
	return 1;
}

////////////////////////////////////////////////////////////////////////////
// Gestionnaire d'vnements de la boite de dialogues
LRESULT CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)  
{
	RECT  rc;
	// Chaine de car pour le combo box
	char* nbmeta[] = {"10","20","30", "40", "50"};
	char* raymeta[] = {"30","40","50","60","70"};

	// Int des chaines de ar
	int nbmet[] = {10,20,30,40,50};
	int raymet[] = {30,40,50,60,70};
	int i;

	switch(msg)
	{
		// Cration de la bote de dialogue
		case WM_INITDIALOG:
		// Centre de l'cran
		GetWindowRect( hwnd, &rc );
		SetWindowPos( hwnd, HWND_TOP,
						(GetSystemMetrics(SM_CXSCREEN) - rc.right)  / 2,
						(GetSystemMetrics(SM_CYSCREEN) - rc.bottom) / 2,
						0, 0, SWP_NOSIZE);
		// Bouton 1 checked
		SendDlgItemMessage( hwnd, IDC_320240, BM_SETCHECK, 1, 0 );
		for (i=0 ; i<5 ; i++ ) 
		{
			SendDlgItemMessage( hwnd, IDC_NBMETA, CB_ADDSTRING, 0, (int)nbmeta[i] );
		}

		for (i=0 ; i<5 ; i++ ) 
		{
			SendDlgItemMessage( hwnd, IDC_METAR, CB_ADDSTRING, 0, (int)raymeta[i] );
		}
		
		SendDlgItemMessage( hwnd, IDC_NBMETA, CB_SETCURSEL, 1, 0 );
		SendDlgItemMessage( hwnd, IDC_METAR, CB_SETCURSEL, 1, 0 );
		break;

		// Un bouton de commande (le # du bouton est contenu dans le low 8-bit de wParam)
		case WM_COMMAND: 
		{                                                       
			switch(LOWORD(wParam))
			{
				case ID_OK:
					if ( SendDlgItemMessage( hwnd, IDC_320240, BM_GETCHECK,  0, 0)) 
					{ 
						ECRAN_X = 320;
						ECRAN_Y = 240;
					}
					else if ( SendDlgItemMessage( hwnd, IDC_512384, BM_GETCHECK,  0, 0)) 
					{	
						ECRAN_X = 512;
						ECRAN_Y = 384;
					}
					else if ( SendDlgItemMessage( hwnd, IDC_640480, BM_GETCHECK,  0, 0))
					{
						ECRAN_X = 640;
						ECRAN_Y = 480;			
					}
					NB_META = nbmet[ SendDlgItemMessage(hwnd,IDC_NBMETA,CB_GETCURSEL,0,0)];
					RAYON_META = raymet[ SendDlgItemMessage(hwnd,IDC_METAR,CB_GETCURSEL,0,0)];
					Metaball = new META[NB_META];
					EndDialog(hwnd, FALSE);
					break;

				case ID_ABOUT:
					{
						MessageBox(HandlePrincipale,"METABALLS 2D \n\nCode: Krashlog/Creative Impact\nEmail: dores@videotron.ca\nhttp://pages.infinit.net/shaun/\nhttp://pages.infinit.net/pcdesign/creative.impact/","A propos...",MB_OK | MB_ICONINFORMATION);
						break;
					}
				case ID_QUIT: 
					{
						EndDialog(hwnd, FALSE);
						Quitter = TRUE;
						break;
					
					}
			}
			break;
		}
        default: 	
			return FALSE; 
     }
     return TRUE; 
}


////////////////////////////////////////////////////////////////////////////
// Gnre la texture utiliss pour dessiner les metaballs et initialise
// les metaballs avec une position, une velocit et un rayon initial
void InitMetaballs()
{
	// Gnre la texture map
	for (int x =-128; x<128; x++)
		for (int y =-128; y <128; y++)
		{
			float d = (float) sqrt(x*x + y*y);
			if (d <= 128)
			{
				float c = (float) (160*cos(d*3.1415927f/128)+160);
		        if (c>255.0) c = 255.0;
		        Texture[(y+128)*256+x+128] = (unsigned char)c;
			}
			else Texture[(y+128)*256+x+128]=0;
		}
	// Initialise les metaballs
	for (x=0;x<NB_META;x++)
	{
		Metaball[x].X      = (rand()%ECRAN_X);
	    Metaball[x].Y      = (rand()%ECRAN_Y);
		Metaball[x].Vx     = (rand()%10) - 5;
		Metaball[x].Vy     = (rand()%10) - 5;
		Metaball[x].Rayon  = (rand()%RAYON_META) + (RAYON_META/2);
	}
}


////////////////////////////////////////////////////////////////////////////
// Dessine les metaballs
void DrawMetaballs()
{
	float du,dv;
	int dest,ra,cx,cy,u,v,tv;
	unsigned int offset;

	// Lock la surface virtuelle
	SurfaceSecondaire->Lock(NULL,&SurfaceDesc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT,NULL);

	// Ramene un ptr sur la surface secondaire
	virtuel = (UCHAR *)SurfaceDesc.lpSurface; 
	// Vide l'cran virtuel
    memset(virtuel,0,ECRAN_X*ECRAN_Y);
	// Vrification des bordures et changements de direction
	for (int i=0;i<NB_META;i++)
	{
      if ((Metaball[i].X+=Metaball[i].Vx)<0)
      {
        Metaball[i].X = 0;    
		Metaball[i].Vx =-Metaball[i].Vx;
      }
      else if (Metaball[i].X>ECRAN_X-1)
      {
        Metaball[i].X = ECRAN_X-1;
        Metaball[i].Vx =-Metaball[i].Vx;
      }
      if ((Metaball[i].Y+= Metaball[i].Vy)<20)
      {
        Metaball[i].Y=20;
        Metaball[i].Vy=-Metaball[i].Vy;
      }
      else if (Metaball[i].Y>ECRAN_Y-1)
      {
        Metaball[i].Y=ECRAN_Y-1;
        Metaball[i].Vy=-Metaball[i].Vy;
      }
	
	 // Variables de travail pour simplifi le tout
	 ra  = Metaball[i].Rayon;
     cx  = Metaball[i].X;
     cy  = Metaball[i].Y;
	 // Delta U et delta V en 16.16 virgule fixe
     dv  = du = (float)(255 << 16) / (ra+ra); 
     u=v=0;
    
	 // Parcourir de centrey-rayon .. centrey+rayon
     for (int y=cy-ra;y<cy+ra;y++)
     {  
		// Clipping y
        if ((y>=0) && (y<ECRAN_Y))
        {
          u = 0;
          tv = (v >> 16);
          offset=(y*ECRAN_X);    
		  // Parcourir de centrex-rayon .. centrex+rayon
     	  for (int x=cx-ra;x<cx+ra;x++)
          {
			// Clipping x  
            if ((x>=0) && (x<ECRAN_X))
            {
				// Addition du pixel sur l'cran virtuel et dans la texture
				dest = virtuel[offset+x] + Texture[(tv<<8)+(u>>16)];
				// Ne pas dpasser 255!
				if (dest > 255) dest = 255;
				// L'afficher dans l'cran virtuel
				virtuel[offset+x] = dest;				
            }
			// Suivre le delta X
            u += (int)du;
          }
        }
		// Suivre le delta Y
        v += (int)dv;
     }
   }
   // Libre la surface secondaire
   SurfaceSecondaire->Unlock(virtuel);	
   // Flip!
   SurfacePrimaire->Flip(NULL,DDFLIP_WAIT);
}

////////////////////////////////////////////////////////////////////////////
// Fonction principale
int WINAPI WinMain(HINSTANCE hInstance,     // Handle sur l'instance prsente
                   HINSTANCE hPrevInstance, // Handle sur l'instance prcdente
                   LPSTR lpCmbLine,         // Ptr sur les arguments
                   int nCmdShow)            // tat de la fentre
{
	MSG	Msg;
	InstancePrincipale = hInstance; // Sauvegarde de l'instance principale
	DialogBox(InstancePrincipale, MAKEINTRESOURCE(IDD_MENU), NULL, ( DLGPROC ) DlgProc);
	EndDialog(HandlePrincipale, FALSE);

	// Initialise et affiche la fentre principale
	if (!Quitter)
	{
		if(!InitFenetre()) Quitter = TRUE;
		if(!InitDirectDraw()) Quitter = TRUE;
	}

	// Tant qu'on n'a pas quitter
	while (Quitter == FALSE)
	{
		// Regarde s'il y a un message dans la msg queue
		if (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
		{
			// Vrifie si le message est un WM_QUIT
			if (Msg.message == WM_QUIT)
				Quitter = true;
			else
			{
				// Traduit le message
				TranslateMessage(&Msg);
				// Envoie le message au gestionnaire d'vnements
				DispatchMessage(&Msg);
			}
		}
		DrawMetaballs();
		// Si escape est enfonc, envoyer le message WM_DESTROY dans la queue de messages
		if (Touche(VK_ESCAPE)) PostMessage(HandlePrincipale, WM_DESTROY, 0, 0);
	}
	// Nettoyer la mmoire
	CloseDirectDraw();
	// Retour  Windows
	return Msg.wParam;
}


////////////////////////////////////////////////////////////////////////////
// Initialise DirectDraw (surface primaire & secondaire)
int InitDirectDraw()
{
	// Cration d'un objet DirectDraw
	if (DirectDrawCreate(NULL, &DirectDraw, NULL) != DD_OK)
		return 0;

	// Niveau de coopration (FullScreen et Exclusive)
	if (DirectDraw->SetCooperativeLevel(HandlePrincipale,
	                                    DDSCL_ALLOWMODEX | DDSCL_FULLSCREEN |
								        DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT) != DD_OK)
		return 0;	
	// Slection du mode vido
	if (DirectDraw->SetDisplayMode(ECRAN_X, ECRAN_Y, 8) != DD_OK)
	{
		MessageBox(HandlePrincipale,
		           "Le mode vido dsir n'est pas support par votre pilote. Assurez-vous d'avoir la dernire version du pilote DirectX de votre carte vido.",
		           "Erreur mode vido",
		           MB_OK | MB_ICONERROR);
		return 0;
	}

	// Initialise la structure de description de la surface
	ZeroMemory(&SurfaceDesc,sizeof(SurfaceDesc));
	SurfaceDesc.dwSize            = sizeof(SurfaceDesc);
	SurfaceDesc.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	SurfaceDesc.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_SYSTEMMEMORY | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	SurfaceDesc.dwBackBufferCount = 1;

	// Cration de la surface primaire
	if (DirectDraw->CreateSurface(&SurfaceDesc, &SurfacePrimaire, NULL) != DD_OK)
		return 0;

	// Cration de la surface secondaire (virtuelle)
	SurfaceCap.dwCaps = DDSCAPS_BACKBUFFER;
	SurfacePrimaire->GetAttachedSurface(&SurfaceCap, &SurfaceSecondaire);

	// Gnre une palette pour les metaballs
	for (int i=0;i<256;i++)
	{
		Palette[i].peRed = i;
		Palette[i].peGreen = 0;
		Palette[i].peBlue = i;
	}
	for (i=0;i<63;i++)
	{
		Palette[192+i].peGreen = i * 4;
	}

 	// cre l'objet palette
	DirectDraw->CreatePalette(DDPCAPS_8BIT,Palette,&DirectDrawPal,NULL);
	// Attache la palette 8-bit  la surface primaire
	SurfacePrimaire->SetPalette(DirectDrawPal);

	InitMetaballs();

	// Cacher le curseur de souris
	ShowCursor(FALSE);
	return 1;
}

////////////////////////////////////////////////////////////////////////////
// Libre les objets DirectDraw
void CloseDirectDraw()
{
	delete [] Metaball;
	
	// Libre surface secondaire
	if (SurfaceSecondaire != NULL)
		SurfaceSecondaire->Release();

	// Libre surface primaire
	if (SurfacePrimaire != NULL)
		SurfacePrimaire->Release();
	
	// Libre objet COM DirectDraw
	if (DirectDraw != NULL)
		DirectDraw->Release();

	// Affiche le curseur de souris
	ShowCursor(TRUE);
}

////////////////////////////////////////////////////////////////////////////